/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.binder;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.binder.MeterBinder;

public class ProcessorMetrics
implements MeterBinder {
    @Override
    public void bindTo(MeterRegistry registry) {
        Runtime runtime = Runtime.getRuntime();
        registry.gauge("cpu_total", runtime, Runtime::availableProcessors);
        OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemBean != null && operatingSystemBean.getSystemLoadAverage() >= 0.0) {
            registry.gauge("cpu_load_average", operatingSystemBean, OperatingSystemMXBean::getSystemLoadAverage);
        }
    }
}

