/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.binder;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.Marker;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.MeterRegistry;

class MetricsTurboFilter
extends TurboFilter {
    private final Counter errorCounter;
    private final Counter warnCounter;
    private final Counter infoCounter;
    private final Counter debugCounter;
    private final Counter traceCounter;

    MetricsTurboFilter(MeterRegistry registry) {
        this.errorCounter = registry.counter("logback_events", "level", "error");
        this.warnCounter = registry.counter("logback_events", "level", "warn");
        this.infoCounter = registry.counter("logback_events", "level", "info");
        this.debugCounter = registry.counter("logback_events", "level", "debug");
        this.traceCounter = registry.counter("logback_events", "level", "trace");
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        switch (level.toInt()) {
            case 40000: {
                this.errorCounter.increment();
                break;
            }
            case 30000: {
                this.warnCounter.increment();
                break;
            }
            case 20000: {
                this.infoCounter.increment();
                break;
            }
            case 10000: {
                this.debugCounter.increment();
                break;
            }
            case 5000: {
                this.traceCounter.increment();
            }
        }
        return FilterReply.NEUTRAL;
    }
}

