/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.export.datadog;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.StepDouble;
import com.netflix.spectator.impl.StepLong;
import com.netflix.spectator.impl.StepValue;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

class DatadogDistributionSummary
implements DistributionSummary {
    private final Id id;
    private final StepLong count;
    private final StepLong total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    DatadogDistributionSummary(Id id, Clock clock, long step) {
        this.id = id;
        this.count = new StepLong(0L, clock, step);
        this.total = new StepLong(0L, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(new Tag[]{Statistic.count}), id.withTags(new Tag[]{Statistic.totalAmount}), id.withTags(new Tag[]{Statistic.totalOfSquares}), id.withTags(new Tag[]{Statistic.max})};
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>(4);
        ms.add(this.newMeasurement(this.stats[0], (StepValue)this.count));
        ms.add(this.newMeasurement(this.stats[1], (StepValue)this.total));
        ms.add(this.newMeasurement(this.stats[2], (StepValue)this.totalOfSquares));
        ms.add(this.newMaxMeasurement(this.stats[3], this.max));
        return ms;
    }

    private Measurement newMeasurement(Id mid, StepValue v) {
        double rate = v.pollAsRate();
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, rate);
    }

    private Measurement newMaxMeasurement(Id mid, StepLong v) {
        double maxValue = v.poll();
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, maxValue);
    }

    public void record(long amount) {
        this.count.getCurrent().incrementAndGet();
        if (amount > 0L) {
            this.total.getCurrent().addAndGet(amount);
            this.totalOfSquares.getCurrent().addAndGet((double)amount * (double)amount);
            this.updateMax(this.max.getCurrent(), amount);
        }
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    public long count() {
        return this.count.poll();
    }

    public long totalAmount() {
        return this.total.poll();
    }
}

