/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.name.LdapDN;

public final class EmbeddedLdapServer {
    private final DirectoryService directoryService;
    private final LdapServer ldapServer;
    private static File workingDirectory = new File(System.getProperty("java.io.tmpdir") + "/apacheds-test1");

    private EmbeddedLdapServer(DirectoryService directoryService, LdapServer ldapServer) {
        this.directoryService = directoryService;
        this.ldapServer = ldapServer;
    }

    public static EmbeddedLdapServer newEmbeddedServer(String defaultPartitionName, String defaultPartitionSuffix, int port) throws Exception {
        FileUtils.deleteDirectory((File)workingDirectory);
        DefaultDirectoryService directoryService = new DefaultDirectoryService();
        directoryService.setShutdownHookEnabled(true);
        directoryService.setAllowAnonymousAccess(true);
        directoryService.setWorkingDirectory(workingDirectory);
        directoryService.getChangeLog().setEnabled(false);
        JdbmPartition partition = new JdbmPartition();
        partition.setId(defaultPartitionName);
        partition.setSuffix(defaultPartitionSuffix);
        directoryService.addPartition((Partition)partition);
        directoryService.startup();
        if (!directoryService.getAdminSession().exists(partition.getSuffixDn())) {
            ServerEntry entry = directoryService.newEntry(new LdapDN(defaultPartitionSuffix));
            entry.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
            entry.add("dc", new String[]{defaultPartitionName});
            directoryService.getAdminSession().add(entry);
        }
        LdapServer ldapServer = new LdapServer();
        ldapServer.setDirectoryService((DirectoryService)directoryService);
        TcpTransport ldapTransport = new TcpTransport(port);
        ldapServer.setTransports(new Transport[]{ldapTransport});
        ldapServer.start();
        return new EmbeddedLdapServer((DirectoryService)directoryService, ldapServer);
    }

    public void shutdown() throws Exception {
        this.ldapServer.stop();
        this.directoryService.shutdown();
        FileUtils.deleteDirectory((File)workingDirectory);
    }
}

