/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import java.util.Arrays;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.util.Assert;

public class AttributeCheckContextMapper
implements ContextMapper<DirContextAdapter> {
    private String[] expectedAttributes = new String[0];
    private String[] expectedValues = new String[0];
    private String[] absentAttributes = new String[0];

    public DirContextAdapter mapFromContext(Object ctx) {
        DirContextAdapter adapter = (DirContextAdapter)ctx;
        Assert.isTrue((this.expectedAttributes.length == this.expectedValues.length ? 1 : 0) != 0, (String)"Values and attributes need to have the same length");
        for (int i = 0; i < this.expectedAttributes.length; ++i) {
            String attributeValue = adapter.getStringAttribute(this.expectedAttributes[i]);
            Assert.notNull((Object)attributeValue, (String)("Attribute " + this.expectedAttributes[i] + " was not present"));
            Assert.isTrue((boolean)this.expectedValues[i].equals(attributeValue), (String)("Expected '" + this.expectedValues[i] + "' but got '" + attributeValue + "'"));
        }
        for (String absentAttribute : this.absentAttributes) {
            Assert.isNull((Object)adapter.getStringAttribute(absentAttribute), (String)("Attribute '" + absentAttribute + "' should not be present"));
        }
        return adapter;
    }

    public void setAbsentAttributes(String[] absentAttributes) {
        this.absentAttributes = Arrays.copyOf(absentAttributes, absentAttributes.length);
    }

    public void setExpectedAttributes(String[] expectedAttributes) {
        this.expectedAttributes = Arrays.copyOf(expectedAttributes, expectedAttributes.length);
    }

    public void setExpectedValues(String[] expectedValues) {
        this.expectedValues = Arrays.copyOf(expectedValues, expectedValues.length);
    }
}

