/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import java.util.Arrays;
import junit.framework.Assert;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;

public class AttributeCheckContextMapper
implements ContextMapper<DirContextAdapter> {
    private String[] expectedAttributes = new String[0];
    private String[] expectedValues = new String[0];
    private String[] absentAttributes = new String[0];

    public DirContextAdapter mapFromContext(Object ctx) {
        DirContextAdapter adapter = (DirContextAdapter)ctx;
        Assert.assertEquals((String)"Values and attributes need to have the same length ", (int)this.expectedAttributes.length, (int)this.expectedValues.length);
        for (int i = 0; i < this.expectedAttributes.length; ++i) {
            String attributeValue = adapter.getStringAttribute(this.expectedAttributes[i]);
            Assert.assertNotNull((String)("Attribute " + this.expectedAttributes[i] + " was not present"), (Object)attributeValue);
            Assert.assertEquals((String)this.expectedValues[i], (String)attributeValue);
        }
        for (String absentAttribute : this.absentAttributes) {
            Assert.assertNull((Object)adapter.getStringAttribute(absentAttribute));
        }
        return adapter;
    }

    public void setAbsentAttributes(String[] absentAttributes) {
        this.absentAttributes = Arrays.copyOf(absentAttributes, absentAttributes.length);
    }

    public void setExpectedAttributes(String[] expectedAttributes) {
        this.expectedAttributes = Arrays.copyOf(expectedAttributes, expectedAttributes.length);
    }

    public void setExpectedValues(String[] expectedValues) {
        this.expectedValues = Arrays.copyOf(expectedValues, expectedValues.length);
    }
}

