/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.tools;

import java.io.PrintStream;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class SchemaViewer {
    private static final String DEFAULT_URL = "ldap://127.0.0.1:389";
    private static final Options options = new Options();
    private static PrintStream outstream;
    private static String WILDCARD;

    private static void printAttrs(Attributes attrs) throws NamingException {
        NamingEnumeration<? extends Attribute> attrsEnum = attrs.getAll();
        while (attrsEnum.hasMore()) {
            Attribute currentAttr = attrsEnum.next();
            outstream.print(String.format("%1$s:", currentAttr.getID()));
            NamingEnumeration<?> valuesEnum = currentAttr.getAll();
            while (valuesEnum.hasMoreElements()) {
                outstream.print(String.format("%1$s ", valuesEnum.nextElement().toString()));
            }
            outstream.println();
        }
    }

    private static void printObject(String contextName, String schemaName, DirContext schemaContext) throws NameNotFoundException, NamingException {
        DirContext oContext = (DirContext)schemaContext.lookup(contextName + "/" + schemaName);
        outstream.println("NAME:" + schemaName);
        SchemaViewer.printAttrs(oContext.getAttributes(""));
    }

    private static void printSchema(String contextName, DirContext schemaContext) throws NameNotFoundException, NamingException {
        outstream.println();
        NamingEnumeration<NameClassPair> schemaList = schemaContext.list(contextName);
        while (schemaList.hasMore()) {
            NameClassPair ncp = (NameClassPair)schemaList.nextElement();
            SchemaViewer.printObject(contextName, ncp.getName(), schemaContext);
            outstream.println();
        }
        outstream.println();
    }

    private static void print(String optionValue, String contextName, DirContext schemaContext) throws NameNotFoundException, NamingException {
        if (optionValue.equals(WILDCARD)) {
            SchemaViewer.printSchema(contextName, schemaContext);
        } else {
            SchemaViewer.printObject(contextName, optionValue, schemaContext);
        }
    }

    public static void main(String[] argv) {
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, argv);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        if (cmd.hasOption(Flag.HELP.getShort())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(120, SchemaViewer.class.getSimpleName(), null, options, null, true);
            System.exit(0);
        }
        if (cmd.hasOption(Flag.ERROR.getShort())) {
            outstream = System.err;
        }
        String url = cmd.getOptionValue(Flag.URL.getShort(), DEFAULT_URL);
        String user = cmd.getOptionValue(Flag.USERNAME.getShort(), "");
        String pass = cmd.getOptionValue(Flag.PASSWORD.getShort(), "");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", url);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (user != null) {
            env.put("java.naming.security.principal", user);
        }
        if (pass != null) {
            env.put("java.naming.security.credentials", pass);
            if (user == null) {
                System.err.println("You must specify a user if you specify a password");
                System.exit(1);
            }
        }
        try {
            InitialDirContext context = new InitialDirContext(env);
            DirContext schemaContext = context.getSchema("");
            if (cmd.hasOption(Flag.OBJECTCLASS.getShort())) {
                SchemaViewer.print(cmd.getOptionValue(Flag.OBJECTCLASS.getShort()), SchemaContext.OBJECTCLASS.getValue(), schemaContext);
            }
            if (cmd.hasOption(Flag.ATTRIBUTE.getShort())) {
                SchemaViewer.print(cmd.getOptionValue(Flag.ATTRIBUTE.getShort()), SchemaContext.ATTRIBUTE.getValue(), schemaContext);
            }
            if (cmd.hasOption(Flag.SYNTAX.getShort())) {
                SchemaViewer.print(cmd.getOptionValue(Flag.SYNTAX.getShort()), SchemaContext.SYNTAX.getValue(), schemaContext);
            }
        }
        catch (AuthenticationException e) {
            System.err.println(String.format("Failed to bind to ldap server at %1$s", url));
        }
        catch (CommunicationException e) {
            System.err.println(String.format("Failed to contact ldap server at %1$s", url));
        }
        catch (NameNotFoundException e) {
            System.err.println(String.format("Can't find object %1$s", e.getMessage()));
        }
        catch (NamingException e) {
            System.err.println(e.toString());
        }
    }

    static {
        options.addOption(Flag.URL.getShort(), Flag.URL.getLong(), true, "Ldap url (defaults to ldap://127.0.0.1:389)");
        options.addOption(Flag.USERNAME.getShort(), Flag.USERNAME.getLong(), true, "DN to bind with (defaults to \"\")");
        options.addOption(Flag.PASSWORD.getShort(), Flag.PASSWORD.getLong(), true, "Password to bind with defaults to \"\")");
        options.addOption(Flag.OBJECTCLASS.getShort(), Flag.OBJECTCLASS.getLong(), true, "Object class name or ? for all. Print object class schema");
        options.addOption(Flag.ATTRIBUTE.getShort(), Flag.ATTRIBUTE.getLong(), true, "Attribute name or ? for all. Print attribute schema");
        options.addOption(Flag.SYNTAX.getShort(), Flag.SYNTAX.getLong(), true, "Syntax OID or ? for all. Print attribute syntax");
        options.addOption(Flag.HELP.getShort(), Flag.HELP.getLong(), false, "Print this help message");
        options.addOption(Flag.ERROR.getShort(), Flag.ERROR.getLong(), false, "Send output to standard error");
        outstream = System.out;
        WILDCARD = "?";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SchemaContext {
        OBJECTCLASS("ClassDefinition"),
        ATTRIBUTE("AttributeDefinition"),
        SYNTAX("SyntaxDefinition");

        private String value;

        private SchemaContext(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("value=%1$s", this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Flag {
        URL("l", "url"),
        USERNAME("u", "username"),
        PASSWORD("p", "password"),
        OBJECTCLASS("o", "objectclass"),
        ATTRIBUTE("a", "attribute"),
        SYNTAX("s", "syntax"),
        HELP("h", "help"),
        ERROR("e", "error");

        private String shortName;
        private String longName;

        private Flag(String shortName, String longName) {
            this.shortName = shortName;
            this.longName = longName;
        }

        public String getShort() {
            return this.shortName;
        }

        public String getLong() {
            return this.longName;
        }

        public String toString() {
            return String.format("short=%1$s, long=%2$s", this.shortName, this.longName);
        }
    }
}

