/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.core.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.simple.ParameterizedContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.odm.core.OdmException;
import org.springframework.ldap.odm.core.OdmManager;
import org.springframework.ldap.odm.core.impl.AttributeMetaData;
import org.springframework.ldap.odm.core.impl.CaseIgnoreString;
import org.springframework.ldap.odm.core.impl.InvalidEntryException;
import org.springframework.ldap.odm.core.impl.ObjectMetaData;
import org.springframework.ldap.odm.core.impl.UnmanagedClassException;
import org.springframework.ldap.odm.typeconversion.ConverterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OdmManagerImpl
implements OdmManager {
    private static final Log LOG = LogFactory.getLog(OdmManagerImpl.class);
    private final LdapOperations ldapTemplate;
    private final ConverterManager converterManager;
    private static String OBJECT_CLASS_ATTRIBUTE = "objectclass";
    private static CaseIgnoreString OBJECT_CLASS_ATTRIBUTE_CI = new CaseIgnoreString(OBJECT_CLASS_ATTRIBUTE);
    private final Map<Class<?>, EntityData> metaDataMap = new HashMap();

    public OdmManagerImpl(ConverterManager converterManager, ContextSource contextSource, Set<Class<?>> managedClasses) {
        this.converterManager = converterManager;
        this.ldapTemplate = new LdapTemplate(contextSource);
        if (managedClasses != null) {
            for (Class<?> managedClass : managedClasses) {
                this.addManagedClass(managedClass);
            }
        }
    }

    public OdmManagerImpl(ConverterManager converterManager, ContextSource contextSource) {
        this(converterManager, contextSource, null);
    }

    private EntityData getEntityData(Class<?> managedClass) {
        EntityData result = this.metaDataMap.get(managedClass);
        if (result == null) {
            throw new UnmanagedClassException(String.format("The %1$s class is not managed by this OdmManager", managedClass));
        }
        return result;
    }

    public void addManagedClass(Class<?> managedClass) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Adding class %1$s to managed set", managedClass));
        }
        ObjectMetaData metaData = new ObjectMetaData(managedClass);
        try {
            managedClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidEntryException(String.format("The class %1$s must have a zero argument constructor to be an Entry", managedClass));
        }
        for (Field field : metaData) {
            AttributeMetaData attributeInfo = metaData.getAttribute(field);
            if (attributeInfo.isId() || attributeInfo.isObjectClass()) continue;
            Class jndiClass = attributeInfo.isBinary() ? byte[].class : String.class;
            Class<?> javaClass = attributeInfo.getValueClass();
            if (!this.converterManager.canConvert(jndiClass, attributeInfo.getSyntax(), javaClass)) {
                throw new InvalidEntryException(String.format("Missing converter from %1$s to %2$s, this is needed for field %3$s on Entry %4$s", jndiClass, javaClass, field.getName(), managedClass));
            }
            if (this.converterManager.canConvert(javaClass, attributeInfo.getSyntax(), jndiClass)) continue;
            throw new InvalidEntryException(String.format("Missing converter from %1$s to %2$s, this is needed for field %3$s on Entry %4$s", javaClass, jndiClass, field.getName(), managedClass));
        }
        AndFilter ocFilter = new AndFilter();
        for (CaseIgnoreString oc : metaData.getObjectClasses()) {
            ocFilter.and((Filter)new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, oc.toString()));
        }
        this.metaDataMap.put(managedClass, new EntityData(metaData, ocFilter.encode()));
    }

    @Override
    public <T> T read(Class<T> clazz, Name dn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Reading Entry at - %s$1", dn));
        }
        this.getEntityData(clazz);
        T result = clazz.cast(this.ldapTemplate.lookup(dn, new GenericContextMapper(clazz)));
        if (result == null) {
            throw new OdmException(String.format("Entry %1$s has excess object classes", dn));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Found entry - %s$1", result));
        }
        return result;
    }

    @Override
    public void create(Object entry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Creating entry - %s$1", entry));
        }
        DirContextAdapter context = new DirContextAdapter(this.getId(entry));
        this.mapToContext(entry, (DirContextOperations)context);
        this.ldapTemplate.bind((DirContextOperations)context);
    }

    @Override
    public void update(Object entry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Updating entry - %s$1", entry));
        }
        DirContextAdapter context = new DirContextAdapter(this.getId(entry));
        this.mapToContext(entry, (DirContextOperations)context);
        this.ldapTemplate.rebind((DirContextOperations)context);
    }

    @Override
    public void delete(Object entry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Deleting %s$1", entry));
        }
        this.getEntityData(entry.getClass());
        this.ldapTemplate.unbind(this.getId(entry));
    }

    private Name getId(Object entry) {
        try {
            return (Name)this.getEntityData(entry.getClass()).metaData.getIdAttribute().getField().get(entry);
        }
        catch (Exception e) {
            throw new InvalidEntryException(String.format("Can't get Id field from Entry %1$s", entry), e);
        }
    }

    @Override
    public <T> List<T> search(Class<T> managedClass, Name base, String filter, SearchControls scope) {
        EntityData entityData = this.getEntityData(managedClass);
        String finalFilter = entityData.ocFilter;
        if (filter != null && filter.length() != 0) {
            StringBuilder fixedFilter = new StringBuilder();
            fixedFilter.append("(&(").append(filter).append(")").append(entityData.ocFilter).append(")");
            finalFilter = fixedFilter.toString();
        }
        Name localBase = base;
        if (base == null || base.size() == 0) {
            localBase = DistinguishedName.EMPTY_PATH;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Searching - base=%1$s, finalFilter=%2$s, scope=%3$s", base, finalFilter, scope));
        }
        List result = this.ldapTemplate.search(localBase, finalFilter, scope, new GenericContextMapper(managedClass));
        result.remove(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Found %1$s Entries - %2$s", result.size(), result));
        }
        return result;
    }

    @Override
    public <T> List<T> findAll(Class<T> managedClass, Name base, SearchControls scope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Searching for all Entries with objectClass=%1$s, with base=%2$s, scope=%3$s", this.getEntityData(managedClass).metaData.getObjectClasses(), base, scope));
        }
        return this.search(managedClass, base, null, scope);
    }

    private void mapToContext(Object entry, DirContextOperations context) {
        ObjectMetaData metaData = this.getEntityData(entry.getClass()).metaData;
        int numOcs = metaData.getObjectClasses().size();
        CaseIgnoreString[] metaDataObjectClasses = metaData.getObjectClasses().toArray(new CaseIgnoreString[numOcs]);
        Object[] stringOcs = new String[numOcs];
        for (int ocIndex = 0; ocIndex < numOcs; ++ocIndex) {
            stringOcs[ocIndex] = metaDataObjectClasses[ocIndex].toString();
        }
        context.setAttributeValues(OBJECT_CLASS_ATTRIBUTE, stringOcs);
        for (Field field : metaData) {
            AttributeMetaData attributeInfo = metaData.getAttribute(field);
            if (attributeInfo.isId() || attributeInfo.isObjectClass()) continue;
            try {
                Class targetClass;
                Class clazz = targetClass = attributeInfo.isBinary() ? byte[].class : String.class;
                if (!attributeInfo.isList()) {
                    Object fieldValue = field.get(entry);
                    if (fieldValue == null) continue;
                    context.setAttributeValue(attributeInfo.getName().toString(), (Object)this.converterManager.convert(fieldValue, attributeInfo.getSyntax(), targetClass));
                    continue;
                }
                ArrayList<String> attributeValues = new ArrayList<String>();
                Collection fieldValues = (Collection)field.get(entry);
                if (fieldValues == null) continue;
                for (Object o : fieldValues) {
                    if (o == null) continue;
                    attributeValues.add((String)this.converterManager.convert(o, attributeInfo.getSyntax(), targetClass));
                }
                context.setAttributeValues(attributeInfo.getName().toString(), attributeValues.toArray());
            }
            catch (IllegalAccessException e) {
                throw new InvalidEntryException(String.format("Can't set attribute %1$s", attributeInfo.getName()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GenericContextMapper<T>
    implements ParameterizedContextMapper<T> {
        private final Class<T> managedClass;

        private GenericContextMapper(Class<T> managedClass) {
            this.managedClass = managedClass;
        }

        public T mapFromContext(Object object) {
            T result;
            block15: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Converting to Java Entry class %1$s from %2$s", this.managedClass, object));
                }
                result = null;
                DirContextOperations context = (DirContextOperations)object;
                ObjectMetaData metaData = OdmManagerImpl.this.getEntityData(this.managedClass).metaData;
                try {
                    result = this.managedClass.newInstance();
                    HashMap<CaseIgnoreString, Attribute> attributeValueMap = new HashMap<CaseIgnoreString, Attribute>();
                    Attributes attributes = context.getAttributes();
                    NamingEnumeration<? extends Attribute> attributesEnumeration = attributes.getAll();
                    while (attributesEnumeration.hasMoreElements()) {
                        Attribute currentAttribute = (Attribute)attributesEnumeration.nextElement();
                        attributeValueMap.put(new CaseIgnoreString(currentAttribute.getID()), currentAttribute);
                    }
                    for (Field field : metaData) {
                        AttributeMetaData attributeInfo = metaData.getAttribute(field);
                        if (!attributeInfo.isId()) {
                            if (!attributeInfo.isList()) {
                                Object value;
                                Attribute attribute = (Attribute)attributeValueMap.get(attributeInfo.getName());
                                if (attribute == null || (value = attribute.get()) == null) continue;
                                Object convertedValue = OdmManagerImpl.this.converterManager.convert(value, attributeInfo.getSyntax(), attributeInfo.getValueClass());
                                field.set(result, convertedValue);
                                continue;
                            }
                            ArrayList fieldValues = new ArrayList();
                            Attribute currentAttribute = (Attribute)attributeValueMap.get(attributeInfo.getName());
                            if (currentAttribute != null) {
                                NamingEnumeration<?> valuesEmumeration = currentAttribute.getAll();
                                while (valuesEmumeration.hasMore()) {
                                    Object value = valuesEmumeration.nextElement();
                                    if (value == null) continue;
                                    fieldValues.add(OdmManagerImpl.this.converterManager.convert(value, attributeInfo.getSyntax(), attributeInfo.getValueClass()));
                                }
                            }
                            field.set(result, fieldValues);
                            continue;
                        }
                        field.set(result, OdmManagerImpl.this.converterManager.convert(context.getDn(), attributeInfo.getSyntax(), attributeInfo.getValueClass()));
                    }
                    Attribute ocAttribute = (Attribute)attributeValueMap.get(OBJECT_CLASS_ATTRIBUTE_CI);
                    if (ocAttribute != null) {
                        HashSet<CaseIgnoreString> objectClassesFromJndi = new HashSet<CaseIgnoreString>();
                        NamingEnumeration<?> objectClassesFromJndiEnum = ocAttribute.getAll();
                        while (objectClassesFromJndiEnum.hasMoreElements()) {
                            objectClassesFromJndi.add(new CaseIgnoreString((String)objectClassesFromJndiEnum.nextElement()));
                        }
                        if (!((Object)objectClassesFromJndi).equals(metaData.getObjectClasses())) {
                            return null;
                        }
                        break block15;
                    }
                    throw new InvalidEntryException(String.format("No object classes were returned for class %1$s", this.managedClass.getName()));
                }
                catch (NamingException ne) {
                    throw new InvalidEntryException(String.format("Problem creating %1$s from LDAP Entry %2$s", this.managedClass, object), ne);
                }
                catch (IllegalAccessException iae) {
                    throw new InvalidEntryException(String.format("Could not create an instance of %1$s could not access field", this.managedClass.getName()), iae);
                }
                catch (InstantiationException ie) {
                    throw new InvalidEntryException(String.format("Could not instantiate %1$s", this.managedClass), ie);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Converted object - %1$s", result));
            }
            return result;
        }
    }

    private static final class EntityData {
        private final ObjectMetaData metaData;
        private final String ocFilter;

        private EntityData(ObjectMetaData metaData, String ocFilter) {
            this.metaData = metaData;
            this.ocFilter = ocFilter;
        }
    }
}

