/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.BatchMessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.BatchToRecordAdapter;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordMessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.ShareRecordMessagingMessageListenerAdapter;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class MethodKafkaListenerEndpoint<K, V>
extends AbstractKafkaListenerEndpoint<K, V> {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private Object bean;
    private Method method;
    private @Nullable MessageHandlerMethodFactory messageHandlerMethodFactory;
    private @Nullable KafkaListenerErrorHandler errorHandler;
    private @Nullable SmartMessageConverter messagingConverter;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setErrorHandler(KafkaListenerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    private @Nullable String getReplyTopic() {
        SendTo ann;
        Method replyingMethod = this.getMethod();
        if (replyingMethod != null && (ann = (SendTo)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)replyingMethod, SendTo.class)) != null) {
            ConfigurableListableBeanFactory configurableListableBeanFactory;
            Object[] destinations;
            if (replyingMethod.getReturnType().equals(Void.TYPE)) {
                this.logger.warn(() -> "Method " + String.valueOf(replyingMethod) + " has a void return type; @SendTo is ignored" + (this.errorHandler == null ? "" : " unless the error handler returns a result"));
            }
            if ((destinations = ann.value()).length > 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + String.valueOf(replyingMethod) + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            String topic = destinations.length == 1 ? destinations[0] : "";
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory instanceof ConfigurableListableBeanFactory && (topic = (configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory).resolveEmbeddedValue(topic)) != null) {
                topic = this.resolve(topic);
            }
            return topic;
        }
        return null;
    }

    protected @Nullable MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    @Override
    protected MessagingMessageListenerAdapter<K, V> createMessageListener(MessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        MessagingMessageListenerAdapter<K, V> messageListener = this.createMessageListenerInstance(messageConverter);
        messageListener.setHandlerMethod(this.configureListenerAdapter(messageListener));
        JavaUtils.INSTANCE.acceptIfNotNull(this.getReplyTopic(), replyTopic -> {
            Assert.state((this.getMethod().getReturnType().equals(Void.TYPE) || this.getReplyTemplate() != null ? 1 : 0) != 0, (String)"a KafkaTemplate is required to support replies");
            messageListener.setReplyTopic((String)replyTopic);
        }).acceptIfNotNull(this.getReplyTemplate(), messageListener::setReplyTemplate);
        return messageListener;
    }

    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter<K, V> messageListener) {
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"MessageHandlerMethodFactory must not be null");
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected MessagingMessageListenerAdapter<K, V> createMessageListenerInstance(@Nullable MessageConverter messageConverter) {
        BeanResolver resolver;
        MessagingMessageListenerAdapter listener;
        if (this.isShareConsumer()) {
            messageListener = new ShareRecordMessagingMessageListenerAdapter(this.bean, this.method, this.errorHandler);
            if (messageConverter instanceof RecordMessageConverter) {
                RecordMessageConverter recordMessageConverter = (RecordMessageConverter)messageConverter;
                messageListener.setMessageConverter(recordMessageConverter);
            }
            listener = messageListener;
        } else if (this.isBatchListener()) {
            messageListener = new BatchMessagingMessageListenerAdapter(this.bean, this.method, this.errorHandler);
            BatchToRecordAdapter batchToRecordAdapter = this.getBatchToRecordAdapter();
            if (batchToRecordAdapter != null) {
                ((BatchMessagingMessageListenerAdapter)messageListener).setBatchToRecordAdapter(batchToRecordAdapter);
            }
            if (messageConverter instanceof BatchMessageConverter) {
                BatchMessageConverter batchMessageConverter = (BatchMessageConverter)messageConverter;
                ((BatchMessagingMessageListenerAdapter)messageListener).setBatchMessageConverter(batchMessageConverter);
            }
            listener = messageListener;
        } else {
            messageListener = new RecordMessagingMessageListenerAdapter(this.bean, this.method, this.errorHandler);
            if (messageConverter instanceof RecordMessageConverter) {
                RecordMessageConverter recordMessageConverter = (RecordMessageConverter)messageConverter;
                messageListener.setMessageConverter(recordMessageConverter);
            }
            listener = messageListener;
        }
        if (this.messagingConverter != null) {
            listener.setMessagingConverter(this.messagingConverter);
        }
        if ((resolver = this.getBeanResolver()) != null) {
            listener.setBeanResolver(resolver);
        }
        return listener;
    }

    private @Nullable String resolve(String value) {
        BeanExpressionContext beanExpressionContext = this.getBeanExpressionContext();
        BeanExpressionResolver resolver = this.getResolver();
        if (resolver != null && beanExpressionContext != null) {
            Object newValue = resolver.evaluate(value, beanExpressionContext);
            Assert.isInstanceOf(String.class, (Object)newValue, (String)"Invalid @SendTo expression");
            return (String)newValue;
        }
        return value;
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }
}

