/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.format.annotation.DurationFormat;
import org.springframework.format.datetime.standard.DurationFormatterUtils;
import org.springframework.kafka.annotation.BackOff;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.util.backoff.FixedBackOff;

final class BackOffFactory {
    private static final long DEFAULT_DELAY = 1000L;
    private final @Nullable StringValueResolver embeddedValueResolver;

    BackOffFactory(@Nullable StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }

    org.springframework.util.backoff.BackOff createFromAnnotation(BackOff annotation) {
        Duration delay = this.resolveDuration("delay", () -> annotation.delay() == 1000L ? annotation.value() : annotation.delay(), annotation::delayString);
        Duration maxDelay = this.resolveDuration("maxDelay", annotation::maxDelay, annotation::maxDelayString);
        double multiplier = this.resolveMultiplier(annotation);
        Duration jitter = this.resolveDuration("jitter", annotation::jitter, annotation::jitterString);
        if (maxDelay == Duration.ZERO && multiplier == 0.0 && jitter == Duration.ZERO) {
            Assert.isTrue((!delay.isNegative() ? 1 : 0) != 0, () -> "Invalid delay (%dms): must be >= 0.".formatted(delay.toMillis()));
            return new FixedBackOff(delay.toMillis());
        }
        RetryPolicy.Builder retryPolicyBuilder = RetryPolicy.builder().maxRetries(Long.MAX_VALUE);
        retryPolicyBuilder.delay(delay);
        if (maxDelay != Duration.ZERO) {
            retryPolicyBuilder.maxDelay(maxDelay);
        }
        if (multiplier != 0.0) {
            retryPolicyBuilder.multiplier(multiplier);
        }
        if (jitter != Duration.ZERO) {
            retryPolicyBuilder.jitter(jitter);
        }
        return retryPolicyBuilder.build().getBackOff();
    }

    private Duration resolveDuration(String attributeName, Supplier<@Nullable Long> valueRaw, Supplier<String> valueString) {
        String resolvedValue = this.resolve(valueString.get());
        if (StringUtils.hasLength((String)resolvedValue)) {
            try {
                return BackOffFactory.toDuration(resolvedValue, TimeUnit.MILLISECONDS);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Invalid duration value for '%s': '%s'; %s".formatted(attributeName, resolvedValue, ex));
            }
        }
        Long raw = valueRaw.get();
        return raw != null && raw != 0L ? Duration.ofMillis(raw) : Duration.ZERO;
    }

    private Double resolveMultiplier(BackOff annotation) {
        String resolvedMultiplier = this.resolve(annotation.multiplierString());
        if (StringUtils.hasLength((String)resolvedMultiplier)) {
            try {
                return Double.valueOf(resolvedMultiplier);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid multiplier: '%s'; %s".formatted(resolvedMultiplier, ex));
            }
        }
        return annotation.multiplier();
    }

    private @Nullable String resolve(String valueString) {
        if (StringUtils.hasLength((String)valueString) && this.embeddedValueResolver != null) {
            return this.embeddedValueResolver.resolveStringValue(valueString);
        }
        return valueString;
    }

    private static Duration toDuration(String valueToResolve, TimeUnit timeUnit) {
        DurationFormat.Unit unit = DurationFormat.Unit.fromChronoUnit((ChronoUnit)timeUnit.toChronoUnit());
        return DurationFormatterUtils.detectAndParse((String)valueToResolve, (DurationFormat.Unit)unit);
    }
}

