/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.JsonProjectingMethodInterceptorFactory;
import org.springframework.kafka.support.JacksonMapperUtils;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.kafka.support.converter.StringJacksonJsonMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.json.JsonMapper;

public class JacksonProjectingMessageConverter
extends MessagingMessageConverter {
    private final ProjectionFactory projectionFactory;
    private final MessagingMessageConverter delegate;

    public JacksonProjectingMessageConverter() {
        this(JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonProjectingMessageConverter(JsonMapper mapper) {
        this(mapper, new StringJacksonJsonMessageConverter());
    }

    public JacksonProjectingMessageConverter(MessagingMessageConverter delegate) {
        this(JacksonMapperUtils.enhancedJsonMapper(), delegate);
    }

    public JacksonProjectingMessageConverter(JsonMapper mapper, MessagingMessageConverter delegate) {
        Assert.notNull((Object)mapper, (String)"JsonMapper must not be null");
        Assert.notNull((Object)delegate, (String)"'delegate' cannot be null");
        Jackson3MappingProvider provider = new Jackson3MappingProvider(mapper);
        JsonProjectingMethodInterceptorFactory interceptorFactory = new JsonProjectingMethodInterceptorFactory((MappingProvider)provider);
        SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
        factory.registerMethodInvokerFactory((MethodInterceptorFactory)interceptorFactory);
        this.projectionFactory = factory;
        this.delegate = delegate;
    }

    @Override
    protected @Nullable Object convertPayload(Message<?> message) {
        return this.delegate.convertPayload(message);
    }

    @Override
    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, @Nullable Type type) {
        Object value = record.value();
        if (value == null) {
            return KafkaNull.INSTANCE;
        }
        Class rawType = ResolvableType.forType((Type)type).resolve(Object.class);
        if (!rawType.isInterface()) {
            return this.delegate.extractAndConvertValue(record, type);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(JacksonProjectingMessageConverter.getAsByteArray(value));
        return this.projectionFactory.createProjection(rawType, (Object)inputStream);
    }

    private static byte[] getAsByteArray(Object source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        if (source instanceof String) {
            return ((String)source).getBytes(StandardCharsets.UTF_8);
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof Bytes) {
            return ((Bytes)source).get();
        }
        throw new ConversionException(String.format("Unsupported payload type '%s'. Expected 'String', 'Bytes', or 'byte[]'", source.getClass()), null);
    }

    private record Jackson3MappingProvider(JsonMapper jsonMapper) implements MappingProvider
    {
        public <T> @Nullable T map(@Nullable Object source, Class<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            try {
                return (T)this.jsonMapper.convertValue(source, targetType);
            }
            catch (Exception ex) {
                throw new MappingException((Throwable)ex);
            }
        }

        public <T> @Nullable T map(@Nullable Object source, TypeRef<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            JavaType type = this.jsonMapper.constructType(targetType.getType());
            try {
                return (T)this.jsonMapper.convertValue(source, type);
            }
            catch (Exception ex) {
                throw new MappingException((Throwable)ex);
            }
        }
    }
}

