/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import org.jspecify.annotations.Nullable;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.RetryTopicNamesProviderFactory;
import org.springframework.kafka.support.Suffixer;

public class SuffixingRetryTopicNamesProviderFactory
implements RetryTopicNamesProviderFactory {
    @Override
    public RetryTopicNamesProviderFactory.RetryTopicNamesProvider createRetryTopicNamesProvider(DestinationTopic.Properties properties) {
        return new SuffixingRetryTopicNamesProvider(properties);
    }

    public static class SuffixingRetryTopicNamesProvider
    implements RetryTopicNamesProviderFactory.RetryTopicNamesProvider {
        private final Suffixer suffixer;

        public SuffixingRetryTopicNamesProvider(DestinationTopic.Properties properties) {
            this.suffixer = new Suffixer(properties.suffix());
        }

        @Override
        public @Nullable String getEndpointId(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getId());
        }

        @Override
        public @Nullable String getGroupId(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getGroupId());
        }

        @Override
        public @Nullable String getClientIdPrefix(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getClientIdPrefix());
        }

        @Override
        public @Nullable String getGroup(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getGroup());
        }

        @Override
        public @Nullable String getTopicName(String topic) {
            return this.suffixer.maybeAddTo(topic);
        }
    }
}

