/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jspecify.annotations.Nullable;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DltStrategy;
import org.springframework.kafka.retrytopic.SameIntervalTopicReuseStrategy;
import org.springframework.kafka.retrytopic.TopicSuffixingStrategy;
import org.springframework.util.StringUtils;

public class DestinationTopicPropertiesFactory {
    private static final String MAIN_TOPIC_SUFFIX = "";
    private final DestinationTopicSuffixes destinationTopicSuffixes;
    private final List<Long> backOffValues;
    private final int numPartitions;
    private final int maxAttempts;
    private final boolean isSameIntervalReuse;
    private final boolean isFixedDelay;
    private final int retryTopicsAmount;
    private final BiPredicate<Integer, Throwable> shouldRetryOn;
    private final KafkaOperations<?, ?> kafkaOperations;
    private final DltStrategy dltStrategy;
    private final long timeout;
    private final Map<String, Set<Class<? extends Throwable>>> dltRoutingRules;
    private @Nullable Boolean autoStartDltHandler;

    public DestinationTopicPropertiesFactory(String retryTopicSuffix, String dltSuffix, List<Long> backOffValues, BinaryExceptionClassifier exceptionClassifier, int numPartitions, KafkaOperations<?, ?> kafkaOperations, DltStrategy dltStrategy, TopicSuffixingStrategy topicSuffixingStrategy, SameIntervalTopicReuseStrategy sameIntervalTopicReuseStrategy, long timeout) {
        this(retryTopicSuffix, dltSuffix, backOffValues, exceptionClassifier, numPartitions, kafkaOperations, dltStrategy, topicSuffixingStrategy, sameIntervalTopicReuseStrategy, timeout, Collections.emptyMap());
    }

    public DestinationTopicPropertiesFactory(@Nullable String retryTopicSuffix, @Nullable String dltSuffix, List<Long> backOffValues, BinaryExceptionClassifier exceptionClassifier, int numPartitions, KafkaOperations<?, ?> kafkaOperations, DltStrategy dltStrategy, TopicSuffixingStrategy topicSuffixingStrategy, SameIntervalTopicReuseStrategy sameIntervalTopicReuseStrategy, long timeout, Map<String, Set<Class<? extends Throwable>>> dltRoutingRules) {
        this.dltStrategy = dltStrategy;
        this.kafkaOperations = kafkaOperations;
        this.numPartitions = numPartitions;
        this.timeout = timeout;
        this.destinationTopicSuffixes = new DestinationTopicSuffixes(retryTopicSuffix, dltSuffix);
        this.dltRoutingRules = this.copyDltRoutingRules(dltRoutingRules);
        this.backOffValues = backOffValues;
        int backOffValuesSize = this.backOffValues.size();
        this.isSameIntervalReuse = SameIntervalTopicReuseStrategy.SINGLE_TOPIC.equals((Object)sameIntervalTopicReuseStrategy);
        this.isFixedDelay = TopicSuffixingStrategy.SUFFIX_WITH_INDEX_VALUE.equals((Object)topicSuffixingStrategy) || backOffValuesSize > 1 && backOffValues.stream().distinct().count() == 1L;
        this.maxAttempts = backOffValuesSize + 1;
        this.shouldRetryOn = (attempt, throwable) -> attempt < this.maxAttempts && exceptionClassifier.classify(throwable) != false;
        this.retryTopicsAmount = backOffValuesSize - this.reusableTopicAttempts();
    }

    private Map<String, Set<Class<? extends Throwable>>> copyDltRoutingRules(Map<String, Set<Class<? extends Throwable>>> dltRoutingRules) {
        HashMap<String, Set<Class<? extends Throwable>>> copyOfDltRoutingRules = new HashMap<String, Set<Class<? extends Throwable>>>();
        dltRoutingRules.forEach((topicSuffix, exceptions) -> copyOfDltRoutingRules.put((String)topicSuffix, new HashSet(exceptions)));
        return copyOfDltRoutingRules;
    }

    public DestinationTopicPropertiesFactory autoStartDltHandler(@Nullable Boolean autoStart) {
        this.autoStartDltHandler = autoStart;
        return this;
    }

    public List<DestinationTopic.Properties> createProperties() {
        ArrayList<DestinationTopic.Properties> list = new ArrayList<DestinationTopic.Properties>(this.retryTopicsAmount + 2);
        list.add(this.createMainTopicProperties());
        for (int backOffIndex = 0; backOffIndex < this.retryTopicsAmount; ++backOffIndex) {
            list.add(this.createRetryProperties(backOffIndex));
        }
        if (!DltStrategy.NO_DLT.equals((Object)this.dltStrategy)) {
            list.addAll(this.createCustomDltProperties());
            list.add(this.createDltProperties());
        }
        return Collections.unmodifiableList(list);
    }

    private DestinationTopic.Properties createMainTopicProperties() {
        return new DestinationTopic.Properties(0L, MAIN_TOPIC_SUFFIX, DestinationTopic.Type.MAIN, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations, this.shouldRetryOn, this.timeout);
    }

    private DestinationTopic.Properties createDltProperties() {
        return new DestinationTopic.Properties(0L, this.destinationTopicSuffixes.getDltSuffix(), DestinationTopic.Type.DLT, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations, (a, e) -> false, this.timeout, this.autoStartDltHandler, Collections.emptySet());
    }

    private List<DestinationTopic.Properties> createCustomDltProperties() {
        return this.dltRoutingRules.entrySet().stream().map(entry -> new DestinationTopic.Properties(0L, (String)entry.getKey() + this.destinationTopicSuffixes.getDltSuffix(), DestinationTopic.Type.DLT, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations, (a, e) -> false, this.timeout, this.autoStartDltHandler, (Set)entry.getValue())).toList();
    }

    private DestinationTopic.Properties createRetryProperties(int backOffIndex) {
        long thisBackOffValue = this.backOffValues.get(backOffIndex);
        return this.createProperties(thisBackOffValue, this.getTopicSuffix(backOffIndex, thisBackOffValue));
    }

    private String getTopicSuffix(int backOffIndex, long thisBackOffValue) {
        if (this.isSameIntervalReuse && this.retryTopicsAmount == 1) {
            return this.destinationTopicSuffixes.getRetrySuffix();
        }
        if (this.isFixedDelay) {
            return this.joinWithRetrySuffix(backOffIndex);
        }
        String retrySuffix = this.joinWithRetrySuffix(thisBackOffValue);
        if (!this.isSameIntervalReuse && this.hasDuplicates(thisBackOffValue)) {
            return retrySuffix.concat("-" + (backOffIndex - this.backOffValues.indexOf(thisBackOffValue)));
        }
        return retrySuffix;
    }

    private DestinationTopic.Type getDestinationTopicType(Long backOffValue) {
        return this.isSameIntervalReuse && this.hasDuplicates(backOffValue) ? DestinationTopic.Type.REUSABLE_RETRY_TOPIC : DestinationTopic.Type.RETRY;
    }

    private int reusableTopicAttempts() {
        if (this.isSameIntervalReuse && this.backOffValues.size() > 1) {
            return this.amountOfDuplicates(this.backOffValues.get(this.backOffValues.size() - 1)) - 1;
        }
        return 0;
    }

    private boolean hasDuplicates(Long thisBackOffValue) {
        return this.amountOfDuplicates(thisBackOffValue) > 1;
    }

    private int amountOfDuplicates(Long thisBackOffValue) {
        return Long.valueOf(this.backOffValues.stream().filter(thisBackOffValue::equals).count()).intValue();
    }

    private DestinationTopic.Properties createProperties(long delayMs, String suffix) {
        return new DestinationTopic.Properties(delayMs, suffix, this.getDestinationTopicType(delayMs), this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations, this.shouldRetryOn, this.timeout);
    }

    private String joinWithRetrySuffix(long parameter) {
        return String.join((CharSequence)"-", this.destinationTopicSuffixes.getRetrySuffix(), String.valueOf(parameter));
    }

    public static class DestinationTopicSuffixes {
        private final String retryTopicSuffix;
        private final String dltSuffix;

        public DestinationTopicSuffixes(@Nullable String retryTopicSuffix, @Nullable String dltSuffix) {
            this.retryTopicSuffix = StringUtils.hasText((String)retryTopicSuffix) ? retryTopicSuffix : "-retry";
            this.dltSuffix = StringUtils.hasText((String)dltSuffix) ? dltSuffix : "-dlt";
        }

        public String getRetrySuffix() {
            return this.retryTopicSuffix;
        }

        public String getDltSuffix() {
            return this.dltSuffix;
        }
    }
}

