/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerEndpointAdapter;
import org.springframework.kafka.core.ShareConsumerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.ShareKafkaMessageListenerContainer;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.util.Assert;

public class ShareKafkaListenerContainerFactory<K, V>
implements KafkaListenerContainerFactory<ShareKafkaMessageListenerContainer<K, V>>,
ApplicationEventPublisherAware,
ApplicationContextAware {
    private final ShareConsumerFactory<? super K, ? super V> shareConsumerFactory;
    private @Nullable Boolean autoStartup;
    private @Nullable Integer phase;
    private @Nullable ApplicationEventPublisher applicationEventPublisher;
    private @Nullable ApplicationContext applicationContext;

    public ShareKafkaListenerContainerFactory(ShareConsumerFactory<K, V> shareConsumerFactory) {
        this.shareConsumerFactory = shareConsumerFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(Integer phase) {
        this.phase = phase;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createListenerContainer(KafkaListenerEndpoint endpoint) {
        ShareKafkaMessageListenerContainer<K, V> instance = this.createContainerInstance(endpoint);
        JavaUtils.INSTANCE.acceptIfNotNull(endpoint.getId(), instance::setBeanName);
        if (endpoint instanceof AbstractKafkaListenerEndpoint) {
            AbstractKafkaListenerEndpoint abstractKafkaListenerEndpoint = (AbstractKafkaListenerEndpoint)endpoint;
            this.configureEndpoint(abstractKafkaListenerEndpoint);
        }
        endpoint.setupListenerContainer(instance, null);
        this.initializeContainer(instance, endpoint);
        return instance;
    }

    private void configureEndpoint(AbstractKafkaListenerEndpoint<K, V> endpoint) {
    }

    protected void initializeContainer(ShareKafkaMessageListenerContainer<K, V> instance, KafkaListenerEndpoint endpoint) {
        ContainerProperties properties = instance.getContainerProperties();
        Boolean effectiveAutoStartup = endpoint.getAutoStartup() != null ? endpoint.getAutoStartup() : this.autoStartup;
        JavaUtils.INSTANCE.acceptIfNotNull(effectiveAutoStartup, instance::setAutoStartup).acceptIfNotNull(this.phase, instance::setPhase).acceptIfNotNull(this.applicationContext, instance::setApplicationContext).acceptIfNotNull(this.applicationEventPublisher, instance::setApplicationEventPublisher).acceptIfNotNull(endpoint.getGroupId(), properties::setGroupId).acceptIfNotNull(endpoint.getClientIdPrefix(), properties::setClientId).acceptIfNotNull(endpoint.getConsumerProperties(), properties::setKafkaConsumerProperties);
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createContainer(TopicPartitionOffset ... topicPartitions) {
        throw new UnsupportedOperationException("ShareConsumer does not support explicit partition assignment");
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createContainer(final String ... topics) {
        return this.createContainerInstance(new KafkaListenerEndpointAdapter(this){
            final /* synthetic */ ShareKafkaListenerContainerFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        });
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createContainer(Pattern topicPattern) {
        throw new UnsupportedOperationException("ShareConsumer does not support topic patterns");
    }

    protected ShareKafkaMessageListenerContainer<K, V> createContainerInstance(KafkaListenerEndpoint endpoint) {
        Collection<String> topics = endpoint.getTopics();
        Assert.state((topics != null ? 1 : 0) != 0, (String)"'topics' must not be null");
        return new ShareKafkaMessageListenerContainer<K, V>(this.shareConsumerFactory, new ContainerProperties(topics.toArray(new String[0])));
    }
}

