/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.kafka.config.ContainerPostProcessor;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.BatchToRecordAdapter;
import org.springframework.kafka.listener.adapter.FilteringBatchMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.FilteringMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.ReplyHeadersConfigurer;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractKafkaListenerEndpoint<K, V>
implements KafkaListenerEndpoint,
BeanFactoryAware,
InitializingBean {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private @Nullable String id;
    private @Nullable String groupId;
    private final Collection<String> topics = new ArrayList<String>();
    private @Nullable Pattern topicPattern;
    private final Collection<TopicPartitionOffset> topicPartitions = new ArrayList<TopicPartitionOffset>();
    private @Nullable BeanFactory beanFactory;
    private @Nullable BeanExpressionResolver resolver;
    private @Nullable BeanExpressionContext expressionContext;
    private @Nullable BeanResolver beanResolver;
    private @Nullable String group;
    private @Nullable RecordFilterStrategy<K, V> recordFilterStrategy;
    private boolean ackDiscarded;
    private @Nullable Boolean batchListener;
    private @Nullable KafkaTemplate<?, ?> replyTemplate;
    private @Nullable String clientIdPrefix;
    private @Nullable Integer concurrency;
    private @Nullable Boolean autoStartup;
    private @Nullable ReplyHeadersConfigurer replyHeadersConfigurer;
    private @Nullable Properties consumerProperties;
    private boolean splitIterables = true;
    private @Nullable BatchToRecordAdapter<K, V> batchToRecordAdapter;
    private byte @Nullable [] listenerInfo;
    private @Nullable String correlationHeaderName;
    private @Nullable ContainerPostProcessor<?, ?, ?> containerPostProcessor;
    private @Nullable String mainListenerId;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            this.resolver = configurableListableBeanFactory.getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)configurableListableBeanFactory, null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    protected @Nullable BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected @Nullable BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    protected @Nullable BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    protected @Nullable BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public void setMainListenerId(@Nullable String id) {
        this.mainListenerId = id;
    }

    @Override
    public @Nullable String getMainListenerId() {
        return this.mainListenerId;
    }

    @Override
    public @Nullable String getId() {
        return this.id;
    }

    public void setGroupId(@Nullable String groupId) {
        this.groupId = groupId;
    }

    @Override
    public @Nullable String getGroupId() {
        return this.groupId;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics.clear();
        this.topics.addAll(Arrays.asList(topics));
    }

    @Override
    public Collection<String> getTopics() {
        return Collections.unmodifiableCollection(this.topics);
    }

    public void setTopicPartitions(TopicPartitionOffset ... topicPartitions) {
        Assert.notNull((Object)topicPartitions, (String)"'topics' must not be null");
        this.topicPartitions.clear();
        this.topicPartitions.addAll(Arrays.asList(topicPartitions));
    }

    @Override
    public TopicPartitionOffset @Nullable [] getTopicPartitionsToAssign() {
        return this.topicPartitions.toArray(new TopicPartitionOffset[0]);
    }

    public void setTopicPattern(@Nullable Pattern topicPattern) {
        this.topicPattern = topicPattern;
    }

    @Override
    public @Nullable Pattern getTopicPattern() {
        return this.topicPattern;
    }

    @Override
    public @Nullable String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    public boolean isBatchListener() {
        return this.batchListener != null && this.batchListener != false;
    }

    @Override
    public @Nullable Boolean getBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setReplyTemplate(KafkaTemplate<?, ?> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    protected @Nullable KafkaTemplate<?, ?> getReplyTemplate() {
        return this.replyTemplate;
    }

    protected @Nullable RecordFilterStrategy<? super K, ? super V> getRecordFilterStrategy() {
        return this.recordFilterStrategy;
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<? super K, ? super V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    protected boolean isAckDiscarded() {
        return this.ackDiscarded;
    }

    public void setAckDiscarded(boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    @Override
    public @Nullable String getClientIdPrefix() {
        return this.clientIdPrefix;
    }

    public void setClientIdPrefix(@Nullable String clientIdPrefix) {
        this.clientIdPrefix = clientIdPrefix;
    }

    @Override
    public @Nullable Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(@Nullable Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public @Nullable Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(@Nullable Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setReplyHeadersConfigurer(ReplyHeadersConfigurer replyHeadersConfigurer) {
        this.replyHeadersConfigurer = replyHeadersConfigurer;
    }

    @Override
    public @Nullable Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(@Nullable Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    @Override
    public boolean isSplitIterables() {
        return this.splitIterables;
    }

    public void setSplitIterables(boolean splitIterables) {
        this.splitIterables = splitIterables;
    }

    @Override
    public byte @Nullable [] getListenerInfo() {
        return this.listenerInfo;
    }

    public void setListenerInfo(byte @Nullable [] listenerInfo) {
        this.listenerInfo = listenerInfo;
    }

    protected @Nullable BatchToRecordAdapter<K, V> getBatchToRecordAdapter() {
        return this.batchToRecordAdapter;
    }

    public void setBatchToRecordAdapter(BatchToRecordAdapter<K, V> batchToRecordAdapter) {
        this.batchToRecordAdapter = batchToRecordAdapter;
    }

    public void setCorrelationHeaderName(String correlationHeaderName) {
        this.correlationHeaderName = correlationHeaderName;
    }

    @Override
    public @Nullable ContainerPostProcessor<?, ?, ?> getContainerPostProcessor() {
        return this.containerPostProcessor;
    }

    public void setContainerPostProcessor(ContainerPostProcessor<?, ?, ?> containerPostProcessor) {
        this.containerPostProcessor = containerPostProcessor;
    }

    public void afterPropertiesSet() {
        boolean topicsEmpty = this.getTopics().isEmpty();
        boolean topicPartitionsEmpty = ObjectUtils.isEmpty((Object[])this.getTopicPartitionsToAssign());
        if (!topicsEmpty && !topicPartitionsEmpty) {
            throw new IllegalStateException("Topics or topicPartitions must be provided but not both for " + String.valueOf(this));
        }
        if (!(this.topicPattern == null || topicsEmpty && topicPartitionsEmpty)) {
            throw new IllegalStateException("Only one of topics, topicPartitions or topicPattern must are allowed for " + String.valueOf(this));
        }
        if (this.topicPattern == null && topicsEmpty && topicPartitionsEmpty) {
            throw new IllegalStateException("At least one of topics, topicPartitions or topicPattern must be provided for " + String.valueOf(this));
        }
    }

    @Override
    public void setupListenerContainer(MessageListenerContainer listenerContainer, @Nullable MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    protected abstract MessagingMessageListenerAdapter<K, V> createMessageListener(MessageListenerContainer var1, @Nullable MessageConverter var2);

    private void setupMessageListener(MessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        MessagingMessageListenerAdapter<K, V> adapter = this.createMessageListener(container, messageConverter);
        JavaUtils.INSTANCE.acceptIfNotNull(this.replyHeadersConfigurer, adapter::setReplyHeadersConfigurer).acceptIfNotNull(this.correlationHeaderName, adapter::setCorrelationHeaderName);
        adapter.setSplitIterables(this.splitIterables);
        ConsumerSeekAware messageListener = adapter;
        if (this.recordFilterStrategy != null) {
            if (this.isBatchListener()) {
                if (messageListener.isConsumerRecords()) {
                    this.logger.warn(() -> "Filter strategy is ignored when consuming 'ConsumerRecords' directly instead of a List of records." + (String)(this.id != null ? " listenerId: " + this.id : ""));
                } else {
                    messageListener = new FilteringBatchMessageListenerAdapter<K, V>((BatchMessageListener)((Object)messageListener), this.recordFilterStrategy, this.ackDiscarded);
                }
            } else {
                messageListener = new FilteringMessageListenerAdapter<K, V>((MessageListener)((Object)messageListener), this.recordFilterStrategy, this.ackDiscarded);
            }
        }
        container.setupMessageListener(messageListener);
    }

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append("[").append(this.id).append("] topics='").append(this.topics).append("' | topicPartitions='").append(this.topicPartitions).append("' | topicPattern='").append(this.topicPattern).append("'");
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }
}

