/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerPartitionPausingBackOffManagerFactory;
import org.springframework.kafka.listener.ContainerPausingBackOffHandler;
import org.springframework.kafka.listener.DeadLetterPublishingRecoverer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.KafkaBackOffManagerFactory;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.ListenerContainerPauseService;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.retrytopic.DeadLetterPublishingRecovererFactory;
import org.springframework.kafka.retrytopic.DefaultDestinationTopicResolver;
import org.springframework.kafka.retrytopic.DestinationTopicProcessor;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryConfigurer;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryResolver;
import org.springframework.kafka.retrytopic.RetryTopicComponentFactory;
import org.springframework.kafka.retrytopic.RetryTopicConfigurer;
import org.springframework.kafka.retrytopic.RetryTopicNamesProviderFactory;
import org.springframework.kafka.retrytopic.RetryTopicSchedulerWrapper;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;

public class RetryTopicConfigurationSupport
implements ApplicationContextAware,
SmartInitializingSingleton {
    private final RetryTopicComponentFactory componentFactory = this.createComponentFactory();
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map beans;
        if (this.applicationContext != null && (beans = this.applicationContext.getBeansOfType(RetryTopicConfigurationSupport.class, false, false)).size() > 1) {
            this.logger.warn(() -> "Only one RetryTopicConfigurationSupport object expected, found " + String.valueOf(beans.keySet()) + "; this may result in unexpected behavior");
        }
    }

    @Bean(name={"org.springframework.kafka.retrytopic.internalRetryTopicConfigurer"})
    public RetryTopicConfigurer retryTopicConfigurer(@Qualifier(value="org.springframework.kafka.config.internalKafkaConsumerBackOffManager") KafkaConsumerBackoffManager kafkaConsumerBackoffManager, @Qualifier(value="org.springframework.kafka.retrytopic.internalDestinationTopicResolver") DestinationTopicResolver destinationTopicResolver, ObjectProvider<RetryTopicComponentFactory> componentFactoryProvider, BeanFactory beanFactory) {
        RetryTopicComponentFactory compFactory = (RetryTopicComponentFactory)componentFactoryProvider.getIfUnique(() -> this.componentFactory);
        DestinationTopicProcessor destinationTopicProcessor = compFactory.destinationTopicProcessor(destinationTopicResolver);
        DeadLetterPublishingRecovererFactory dlprf = compFactory.deadLetterPublishingRecovererFactory(destinationTopicResolver);
        ListenerContainerFactoryConfigurer lcfc = compFactory.listenerContainerFactoryConfigurer(kafkaConsumerBackoffManager, dlprf, compFactory.internalRetryTopicClock());
        ListenerContainerFactoryResolver factoryResolver = compFactory.listenerContainerFactoryResolver(beanFactory);
        RetryTopicNamesProviderFactory retryTopicNamesProviderFactory = compFactory.retryTopicNamesProviderFactory();
        this.processDeadLetterPublishingContainerFactory(dlprf);
        this.processListenerContainerFactoryConfigurer(lcfc);
        RetryTopicConfigurer retryTopicConfigurer = compFactory.retryTopicConfigurer(destinationTopicProcessor, lcfc, factoryResolver, retryTopicNamesProviderFactory);
        Consumer<RetryTopicConfigurer> configurerConsumer = this.configureRetryTopicConfigurer();
        Assert.notNull(configurerConsumer, (String)"configureRetryTopicConfigurer cannot return null.");
        configurerConsumer.accept(retryTopicConfigurer);
        return retryTopicConfigurer;
    }

    protected Consumer<RetryTopicConfigurer> configureRetryTopicConfigurer() {
        return retryTopicConfigurer -> {};
    }

    private void processDeadLetterPublishingContainerFactory(DeadLetterPublishingRecovererFactory deadLetterPublishingRecovererFactory) {
        CustomizersConfigurer customizersConfigurer = new CustomizersConfigurer();
        this.configureCustomizers(customizersConfigurer);
        JavaUtils.INSTANCE.acceptIfNotNull(customizersConfigurer.getDeadLetterPublishingRecovererCustomizer(), deadLetterPublishingRecovererFactory::setDeadLetterPublishingRecovererCustomizer);
        Consumer<DeadLetterPublishingRecovererFactory> dlprfConsumer = this.configureDeadLetterPublishingContainerFactory();
        Assert.notNull(dlprfConsumer, (String)"configureDeadLetterPublishingContainerFactory must not return null");
        dlprfConsumer.accept(deadLetterPublishingRecovererFactory);
    }

    protected Consumer<DeadLetterPublishingRecovererFactory> configureDeadLetterPublishingContainerFactory() {
        return dlprf -> {};
    }

    private void processListenerContainerFactoryConfigurer(ListenerContainerFactoryConfigurer listenerContainerFactoryConfigurer) {
        CustomizersConfigurer customizersConfigurer = new CustomizersConfigurer();
        this.configureCustomizers(customizersConfigurer);
        BlockingRetriesConfigurer blockingRetriesConfigurer = new BlockingRetriesConfigurer();
        this.configureBlockingRetries(blockingRetriesConfigurer);
        JavaUtils.INSTANCE.acceptIfNotNull(blockingRetriesConfigurer.getBackOff(), listenerContainerFactoryConfigurer::setBlockingRetriesBackOff).acceptIfNotNull(blockingRetriesConfigurer.getRetryableExceptions(), listenerContainerFactoryConfigurer::setBlockingRetryableExceptions).acceptIfNotNull(customizersConfigurer.getErrorHandlerCustomizer(), listenerContainerFactoryConfigurer::setErrorHandlerCustomizer).acceptIfNotNull(customizersConfigurer.getListenerContainerCustomizer(), listenerContainerFactoryConfigurer::setContainerCustomizer);
        listenerContainerFactoryConfigurer.setRetainStandardFatal(true);
        Consumer<ListenerContainerFactoryConfigurer> lcfcConfigurer = this.configureListenerContainerFactoryConfigurer();
        Assert.notNull(lcfcConfigurer, (String)"configureListenerContainerFactoryConfigurer must not return null.");
        lcfcConfigurer.accept(listenerContainerFactoryConfigurer);
    }

    protected Consumer<ListenerContainerFactoryConfigurer> configureListenerContainerFactoryConfigurer() {
        return lcfc -> {};
    }

    protected void configureBlockingRetries(BlockingRetriesConfigurer blockingRetries) {
    }

    protected void manageNonBlockingFatalExceptions(List<Class<? extends Throwable>> nonBlockingRetriesExceptions) {
    }

    protected void configureCustomizers(CustomizersConfigurer customizersConfigurer) {
    }

    @Bean(name={"org.springframework.kafka.retrytopic.internalDestinationTopicResolver"})
    public DestinationTopicResolver destinationTopicResolver(ObjectProvider<RetryTopicComponentFactory> componentFactoryProvider) {
        RetryTopicComponentFactory compFactory = (RetryTopicComponentFactory)componentFactoryProvider.getIfUnique(() -> this.componentFactory);
        DestinationTopicResolver destinationTopicResolver = compFactory.destinationTopicResolver();
        JavaUtils.INSTANCE.acceptIfInstanceOf(DefaultDestinationTopicResolver.class, destinationTopicResolver, this::configureNonBlockingFatalExceptions);
        Consumer<DestinationTopicResolver> resolverConsumer = this.configureDestinationTopicResolver();
        Assert.notNull(resolverConsumer, (String)"customizeDestinationTopicResolver must not return null");
        resolverConsumer.accept(destinationTopicResolver);
        return destinationTopicResolver;
    }

    private void configureNonBlockingFatalExceptions(DefaultDestinationTopicResolver destinationTopicResolver) {
        ArrayList<Class<? extends Throwable>> fatalExceptions = new ArrayList<Class<? extends Throwable>>(ExceptionClassifier.defaultFatalExceptionsList());
        this.manageNonBlockingFatalExceptions(fatalExceptions);
        destinationTopicResolver.setClassifications(fatalExceptions.stream().collect(Collectors.toMap(ex -> ex, ex -> false)), true);
    }

    protected Consumer<DestinationTopicResolver> configureDestinationTopicResolver() {
        return dtr -> {};
    }

    @Bean(name={"org.springframework.kafka.config.internalKafkaConsumerBackOffManager"})
    public KafkaConsumerBackoffManager kafkaConsumerBackoffManager(ApplicationContext applicationContext, @Qualifier(value="org.springframework.kafka.config.internalKafkaListenerEndpointRegistry") @Nullable ListenerContainerRegistry registry, ObjectProvider<RetryTopicComponentFactory> componentFactoryProvider, @Nullable RetryTopicSchedulerWrapper wrapper, @Nullable TaskScheduler taskScheduler) {
        RetryTopicComponentFactory compFactory = (RetryTopicComponentFactory)componentFactoryProvider.getIfUnique(() -> this.componentFactory);
        KafkaBackOffManagerFactory backOffManagerFactory = compFactory.kafkaBackOffManagerFactory(registry, applicationContext);
        JavaUtils.INSTANCE.acceptIfInstanceOf(ContainerPartitionPausingBackOffManagerFactory.class, backOffManagerFactory, factory -> this.configurePartitionPausingFactory((ContainerPartitionPausingBackOffManagerFactory)factory, registry, wrapper != null ? wrapper.getScheduler() : taskScheduler));
        return backOffManagerFactory.create();
    }

    private void configurePartitionPausingFactory(ContainerPartitionPausingBackOffManagerFactory factory, @Nullable ListenerContainerRegistry registry, @Nullable TaskScheduler scheduler) {
        Assert.notNull((Object)scheduler, (String)"Either a RetryTopicSchedulerWrapper or TaskScheduler bean is required");
        factory.setBackOffHandler(new ContainerPausingBackOffHandler(new ListenerContainerPauseService(registry, scheduler)));
    }

    protected RetryTopicComponentFactory createComponentFactory() {
        return new RetryTopicComponentFactory();
    }

    public static class CustomizersConfigurer {
        private @Nullable Consumer<DefaultErrorHandler> errorHandlerCustomizer;
        private @Nullable Consumer<ConcurrentMessageListenerContainer<?, ?>> listenerContainerCustomizer;
        private @Nullable Consumer<DeadLetterPublishingRecoverer> deadLetterPublishingRecovererCustomizer;

        public CustomizersConfigurer customizeErrorHandler(Consumer<DefaultErrorHandler> errorHandlerCustomizer) {
            this.errorHandlerCustomizer = errorHandlerCustomizer;
            return this;
        }

        public CustomizersConfigurer customizeListenerContainer(Consumer<ConcurrentMessageListenerContainer<?, ?>> listenerContainerCustomizer) {
            this.listenerContainerCustomizer = listenerContainerCustomizer;
            return this;
        }

        public CustomizersConfigurer customizeDeadLetterPublishingRecoverer(Consumer<DeadLetterPublishingRecoverer> dlprCustomizer) {
            this.deadLetterPublishingRecovererCustomizer = dlprCustomizer;
            return this;
        }

        @Nullable Consumer<DefaultErrorHandler> getErrorHandlerCustomizer() {
            return this.errorHandlerCustomizer;
        }

        @Nullable Consumer<ConcurrentMessageListenerContainer<?, ?>> getListenerContainerCustomizer() {
            return this.listenerContainerCustomizer;
        }

        @Nullable Consumer<DeadLetterPublishingRecoverer> getDeadLetterPublishingRecovererCustomizer() {
            return this.deadLetterPublishingRecovererCustomizer;
        }
    }

    public static class BlockingRetriesConfigurer {
        private @Nullable BackOff backOff;
        private @Nullable Class<? extends Exception>[] retryableExceptions;

        @SafeVarargs
        public final BlockingRetriesConfigurer retryOn(Class<? extends Exception> ... exceptions) {
            this.retryableExceptions = Arrays.copyOf(exceptions, exceptions.length);
            return this;
        }

        public BlockingRetriesConfigurer backOff(BackOff backoff) {
            this.backOff = backoff;
            return this;
        }

        @Nullable BackOff getBackOff() {
            return this.backOff;
        }

        @Nullable Class<? extends Exception>[] getRetryableExceptions() {
            return this.retryableExceptions;
        }
    }
}

