/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.util.Assert;

public class CompositeRecordInterceptor<K, V>
implements RecordInterceptor<K, V> {
    private final Collection<RecordInterceptor<K, V>> delegates = new ArrayList<RecordInterceptor<K, V>>();

    @SafeVarargs
    public CompositeRecordInterceptor(RecordInterceptor<K, V> ... delegates) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements((Object[])delegates, (String)"'delegates' cannot have null entries");
        this.delegates.addAll(Arrays.asList(delegates));
    }

    @Override
    public @Nullable ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        RecordInterceptor<K, V> delegate;
        ConsumerRecord<K, V> recordToIntercept = record;
        Iterator<RecordInterceptor<K, V>> iterator = this.delegates.iterator();
        while (iterator.hasNext() && (recordToIntercept = (delegate = iterator.next()).intercept(recordToIntercept, consumer)) != null) {
        }
        return recordToIntercept;
    }

    @Override
    public void success(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.delegates.forEach(del -> del.success(record, consumer));
    }

    @Override
    public void failure(ConsumerRecord<K, V> record, Exception exception, Consumer<K, V> consumer) {
        this.delegates.forEach(del -> del.failure(record, exception, consumer));
    }

    @Override
    public void setupThreadState(Consumer<?, ?> consumer) {
        this.delegates.forEach(del -> del.setupThreadState(consumer));
    }

    @Override
    public void clearThreadState(Consumer<?, ?> consumer) {
        this.delegates.forEach(del -> del.clearThreadState(consumer));
    }

    @Override
    public void afterRecord(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.delegates.forEach(del -> del.afterRecord(record, consumer));
    }
}

