/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.listener.adapter.DelegatingInvocableHandler;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.validation.Validator;

public class MultiMethodKafkaListenerEndpoint<K, V>
extends MethodKafkaListenerEndpoint<K, V> {
    private List<Method> methods;
    private @Nullable Method defaultMethod;
    private @Nullable Validator validator;

    public MultiMethodKafkaListenerEndpoint(List<Method> methods, @Nullable Method defaultMethod, Object bean) {
        this.methods = methods;
        this.defaultMethod = defaultMethod;
        this.setBean(bean);
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    public @Nullable Method getDefaultMethod() {
        return this.defaultMethod;
    }

    public void setDefaultMethod(Method defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter<K, V> messageListener) {
        ArrayList<InvocableHandlerMethod> invocableHandlerMethods = new ArrayList<InvocableHandlerMethod>();
        InvocableHandlerMethod defaultHandler = null;
        for (Method method : this.methods) {
            MessageHandlerMethodFactory messageHandlerMethodFactory = this.getMessageHandlerMethodFactory();
            if (messageHandlerMethodFactory == null) continue;
            InvocableHandlerMethod handler = messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), method);
            invocableHandlerMethods.add(handler);
            if (!method.equals(this.defaultMethod)) continue;
            defaultHandler = handler;
        }
        DelegatingInvocableHandler delegatingHandler = new DelegatingInvocableHandler(invocableHandlerMethods, defaultHandler, this.getBean(), this.getResolver(), this.getBeanExpressionContext(), this.getBeanFactory(), this.validator);
        return new HandlerAdapter(delegatingHandler);
    }
}

