/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.TimestampedException;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDestinationTopicResolver
extends ExceptionClassifier
implements DestinationTopicResolver,
ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private static final String NO_OPS_SUFFIX = "-noOps";
    private static final List<Class<? extends Throwable>> FRAMEWORK_EXCEPTIONS = Arrays.asList(ListenerExecutionFailedException.class, TimestampedException.class);
    private final Map<String, Map<String, DestinationTopicHolder>> sourceDestinationsHolderMap;
    private final Lock sourceDestinationsHolderLock = new ReentrantLock();
    private final Clock clock;
    private ApplicationContext applicationContext;
    private boolean contextRefreshed;

    public DefaultDestinationTopicResolver(Clock clock) {
        this.clock = clock;
        this.sourceDestinationsHolderMap = new ConcurrentHashMap<String, Map<String, DestinationTopicHolder>>();
        this.contextRefreshed = false;
    }

    public DefaultDestinationTopicResolver() {
        this(Clock.systemUTC());
    }

    @Override
    public DestinationTopic resolveDestinationTopic(String mainListenerId, String topic, Integer attempt, Exception e, long originalTimestamp) {
        DestinationTopicHolder destinationTopicHolder = this.getDestinationHolderFor(mainListenerId, topic);
        return destinationTopicHolder.getSourceDestination().isDltTopic() ? this.handleDltProcessingFailure(destinationTopicHolder, e) : (destinationTopicHolder.getSourceDestination().shouldRetryOn(attempt, this.maybeUnwrapException(e)) && this.isNotFatalException(e) != false && !this.isPastTimout(originalTimestamp, destinationTopicHolder) ? this.resolveRetryDestination(mainListenerId, destinationTopicHolder, e) : this.getDltOrNoOpsDestination(mainListenerId, topic, e));
    }

    private Boolean isNotFatalException(Exception e) {
        return this.getClassifier().classify((Throwable)e);
    }

    private Throwable maybeUnwrapException(Throwable e) {
        return FRAMEWORK_EXCEPTIONS.stream().filter(frameworkException -> frameworkException.isAssignableFrom(e.getClass())).map(frameworkException -> this.maybeUnwrapException(e.getCause())).findFirst().orElse(e);
    }

    private boolean isPastTimout(long originalTimestamp, DestinationTopicHolder destinationTopicHolder) {
        long timeout = destinationTopicHolder.getNextDestination().getDestinationTimeout();
        return timeout != -1L && Instant.now(this.clock).toEpochMilli() > originalTimestamp + timeout;
    }

    private DestinationTopic handleDltProcessingFailure(DestinationTopicHolder destinationTopicHolder, Exception e) {
        return destinationTopicHolder.getSourceDestination().isAlwaysRetryOnDltFailure() && this.isNotFatalException(e) != false ? destinationTopicHolder.getSourceDestination() : destinationTopicHolder.getNextDestination();
    }

    private DestinationTopic resolveRetryDestination(String mainListenerId, DestinationTopicHolder destinationTopicHolder, Exception e) {
        if (destinationTopicHolder.getSourceDestination().isReusableRetryTopic()) {
            return destinationTopicHolder.getSourceDestination();
        }
        if (DefaultDestinationTopicResolver.isAlreadyDltDestination(destinationTopicHolder)) {
            return this.getDltOrNoOpsDestination(mainListenerId, destinationTopicHolder.getSourceDestination().getDestinationName(), e);
        }
        return destinationTopicHolder.getNextDestination();
    }

    private static boolean isAlreadyDltDestination(DestinationTopicHolder destinationTopicHolder) {
        return destinationTopicHolder.getNextDestination().isDltTopic();
    }

    @Override
    public DestinationTopic getDestinationTopicByName(String mainListenerId, String topic) {
        Map<String, DestinationTopicHolder> map = this.sourceDestinationsHolderMap.get(mainListenerId);
        Assert.notNull(map, () -> "No destination resolution information for listener " + mainListenerId);
        return Objects.requireNonNull(map.get(topic), () -> "No DestinationTopic found for " + mainListenerId + ":" + topic).getSourceDestination();
    }

    @Override
    @Nullable
    public DestinationTopic getDltFor(String mainListenerId, String topicName, Exception e) {
        DestinationTopic destination = this.getDltOrNoOpsDestination(mainListenerId, topicName, e);
        return destination.isNoOpsTopic() ? null : destination;
    }

    private DestinationTopic getDltOrNoOpsDestination(String mainListenerId, String topic, Exception e) {
        DestinationTopic destination = this.getNextDestinationTopicFor(mainListenerId, topic);
        return DefaultDestinationTopicResolver.isMatchingDltTopic(destination, e) || destination.isNoOpsTopic() ? destination : this.getDltOrNoOpsDestination(mainListenerId, destination.getDestinationName(), e);
    }

    private static boolean isMatchingDltTopic(DestinationTopic destination, Exception e) {
        if (!destination.isDltTopic()) {
            return false;
        }
        boolean isDltIntendedForCurrentExc = destination.usedForExceptions().stream().anyMatch(excType -> DefaultDestinationTopicResolver.isDirectExcOrCause(e, excType));
        boolean isGenericPurposeDlt = destination.usedForExceptions().isEmpty();
        return isDltIntendedForCurrentExc || isGenericPurposeDlt;
    }

    private static boolean isDirectExcOrCause(Exception e, Class<? extends Throwable> excType) {
        if (e == null) {
            return false;
        }
        Throwable toMatch = e;
        boolean isMatched = excType.isInstance(toMatch);
        while (!isMatched) {
            if ((toMatch = toMatch.getCause()) == null) {
                return false;
            }
            isMatched = excType.isInstance(toMatch);
        }
        return isMatched;
    }

    @Override
    public DestinationTopic getNextDestinationTopicFor(String mainListenerId, String topic) {
        return this.getDestinationHolderFor(mainListenerId, topic).getNextDestination();
    }

    private DestinationTopicHolder getDestinationHolderFor(String mainListenerId, String topic) {
        return this.contextRefreshed ? this.doGetDestinationFor(mainListenerId, topic) : this.getDestinationTopicSynchronized(mainListenerId, topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationTopicHolder getDestinationTopicSynchronized(String mainListenerId, String topic) {
        try {
            this.sourceDestinationsHolderLock.lock();
            DestinationTopicHolder destinationTopicHolder = this.doGetDestinationFor(mainListenerId, topic);
            return destinationTopicHolder;
        }
        finally {
            this.sourceDestinationsHolderLock.unlock();
        }
    }

    private DestinationTopicHolder doGetDestinationFor(String mainListenerId, String topic) {
        Map<String, DestinationTopicHolder> map = this.sourceDestinationsHolderMap.get(mainListenerId);
        Assert.notNull(map, () -> "No destination resolution information for listener " + mainListenerId);
        return Objects.requireNonNull(map.get(topic), () -> "No destination found for topic: " + topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDestinationTopics(String mainListenerId, List<DestinationTopic> destinationsToAdd) {
        if (this.contextRefreshed) {
            throw new IllegalStateException("Cannot add new destinations, " + DefaultDestinationTopicResolver.class.getSimpleName() + " is already refreshed.");
        }
        this.validateDestinations(destinationsToAdd);
        try {
            this.sourceDestinationsHolderLock.lock();
            Map map = this.sourceDestinationsHolderMap.computeIfAbsent(mainListenerId, id -> new HashMap());
            map.putAll(this.correlatePairSourceAndDestinationValues(destinationsToAdd));
        }
        finally {
            this.sourceDestinationsHolderLock.unlock();
        }
    }

    private void validateDestinations(List<DestinationTopic> destinationsToAdd) {
        for (int i = 0; i < destinationsToAdd.size(); ++i) {
            DestinationTopic destination = destinationsToAdd.get(i);
            if (!destination.isReusableRetryTopic()) continue;
            boolean isLastOrFollowedOnlyByDlts = i == destinationsToAdd.size() - 1 || destinationsToAdd.subList(i + 1, destinationsToAdd.size()).stream().allMatch(DestinationTopic::isDltTopic);
            Assert.isTrue((boolean)isLastOrFollowedOnlyByDlts, () -> String.format("In the destination topic chain, the type %s can only be specified as the last retry topic (followed only by DLT topics).", new Object[]{DestinationTopic.Type.REUSABLE_RETRY_TOPIC}));
        }
    }

    private Map<String, DestinationTopicHolder> correlatePairSourceAndDestinationValues(List<DestinationTopic> destinationList) {
        return IntStream.range(0, destinationList.size()).boxed().collect(Collectors.toMap(index -> ((DestinationTopic)destinationList.get((int)index)).getDestinationName(), index -> new DestinationTopicHolder((DestinationTopic)destinationList.get((int)index), this.getNextDestinationTopic(destinationList, (int)index))));
    }

    private DestinationTopic getNextDestinationTopic(List<DestinationTopic> destinationList, int index) {
        return index != destinationList.size() - 1 ? destinationList.get(index + 1) : new DestinationTopic(destinationList.get(index).getDestinationName() + NO_OPS_SUFFIX, destinationList.get(index), NO_OPS_SUFFIX, DestinationTopic.Type.NO_OPS);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (Objects.equals(event.getApplicationContext(), this.applicationContext)) {
            this.contextRefreshed = true;
        }
    }

    public boolean isContextRefreshed() {
        return this.contextRefreshed;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static class DestinationTopicHolder {
        private final DestinationTopic sourceDestination;
        private final DestinationTopic nextDestination;

        DestinationTopicHolder(DestinationTopic sourceDestination, DestinationTopic nextDestination) {
            this.sourceDestination = sourceDestination;
            this.nextDestination = nextDestination;
        }

        protected DestinationTopic getNextDestination() {
            return this.nextDestination;
        }

        protected DestinationTopic getSourceDestination() {
            return this.sourceDestination;
        }
    }
}

