/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.kafka.core.ProducerFactoryUtils;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class KafkaResourceHolder<K, V>
extends ResourceHolderSupport {
    private final Producer<K, V> producer;
    private final Duration closeTimeout;

    public KafkaResourceHolder(Producer<K, V> producer) {
        this(producer, ProducerFactoryUtils.DEFAULT_CLOSE_TIMEOUT);
    }

    @Deprecated
    public KafkaResourceHolder(Producer<K, V> producer, long closeTimeout) {
        Assert.notNull(producer, (String)"'producer' cannot be null");
        Assert.notNull((Object)closeTimeout, (String)"'closeTimeout' cannot be null");
        this.producer = producer;
        this.closeTimeout = Duration.ofMillis(closeTimeout);
    }

    public KafkaResourceHolder(Producer<K, V> producer, Duration closeTimeout) {
        Assert.notNull(producer, (String)"'producer' cannot be null");
        Assert.notNull((Object)closeTimeout, (String)"'closeTimeout' cannot be null");
        this.producer = producer;
        this.closeTimeout = closeTimeout;
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public void commit() {
        this.producer.commitTransaction();
    }

    public void close() {
        this.producer.close(this.closeTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void rollback() {
        this.producer.abortTransaction();
    }
}

