/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.DefaultKafkaHeaderMapper;
import org.springframework.kafka.support.JacksonPresent;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.KafkaMessageHeaders;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

public class MessagingMessageConverter
implements RecordMessageConverter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean generateMessageId = false;
    private boolean generateTimestamp = false;
    private KafkaHeaderMapper headerMapper;

    public MessagingMessageConverter() {
        if (JacksonPresent.isJackson2Present()) {
            this.headerMapper = new DefaultKafkaHeaderMapper();
        }
    }

    public void setGenerateMessageId(boolean generateMessageId) {
        this.generateMessageId = generateMessageId;
    }

    public void setGenerateTimestamp(boolean generateTimestamp) {
        this.generateTimestamp = generateTimestamp;
    }

    public void setHeaderMapper(KafkaHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    @Override
    public Message<?> toMessage(ConsumerRecord<?, ?> record, Acknowledgment acknowledgment, Type type) {
        KafkaMessageHeaders kafkaMessageHeaders = new KafkaMessageHeaders(this.generateMessageId, this.generateTimestamp);
        Map<String, Object> rawHeaders = kafkaMessageHeaders.getRawHeaders();
        if (this.headerMapper != null) {
            this.headerMapper.toHeaders(record.headers(), rawHeaders);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No header mapper is available; Jackson is required for the default mapper; headers (if present) are not mapped but provided raw in kafka_nativeHeaders");
            }
            rawHeaders.put("kafka_nativeHeaders", record.headers());
        }
        rawHeaders.put("kafka_receivedMessageKey", record.key());
        rawHeaders.put("kafka_receivedTopic", record.topic());
        rawHeaders.put("kafka_receivedPartitionId", record.partition());
        rawHeaders.put("kafka_offset", record.offset());
        rawHeaders.put("kafka_timestampType", record.timestampType().name());
        rawHeaders.put("kafka_receivedTimestamp", record.timestamp());
        if (acknowledgment != null) {
            rawHeaders.put("kafka_acknowledgment", acknowledgment);
        }
        return MessageBuilder.createMessage((Object)this.extractAndConvertValue(record, type), (MessageHeaders)kafkaMessageHeaders);
    }

    @Override
    public ProducerRecord<?, ?> fromMessage(Message<?> message, String defaultTopic) {
        MessageHeaders headers = message.getHeaders();
        String topic = (String)headers.get((Object)"kafka_topic", String.class);
        Integer partition = (Integer)headers.get((Object)"kafka_partitionId", Integer.class);
        Object key = headers.get((Object)"kafka_messageKey");
        Object payload = this.convertPayload(message);
        Long timestamp = (Long)headers.get((Object)"kafka_timestamp", Long.class);
        RecordHeaders recordHeaders = new RecordHeaders();
        if (this.headerMapper != null) {
            this.headerMapper.fromHeaders(headers, (Headers)recordHeaders);
        }
        return new ProducerRecord(topic == null ? defaultTopic : topic, partition, timestamp, key, payload, (Iterable)recordHeaders);
    }

    protected Object convertPayload(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof KafkaNull) {
            return null;
        }
        return payload;
    }

    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        return record.value() == null ? KafkaNull.INSTANCE : record.value();
    }
}

