/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.AbstractFilteringMessageListener;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;

public class FilteringMessageListenerAdapter<K, V>
extends AbstractFilteringMessageListener<K, V>
implements MessageListener<K, V> {
    private final MessageListener<K, V> delegate;

    public FilteringMessageListenerAdapter(MessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy) {
        super(recordFilterStrategy);
        this.delegate = delegate;
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> consumerRecord) {
        if (!this.filter(consumerRecord)) {
            this.delegate.onMessage(consumerRecord);
        }
    }
}

