/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.junit;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.EmbeddedKafkaKraftBroker;
import org.springframework.kafka.test.EmbeddedKafkaZKBroker;
import org.springframework.util.StringUtils;

public class GlobalEmbeddedKafkaTestExecutionListener
implements TestExecutionListener {
    public static final String LISTENER_ENABLED_PROPERTY_NAME = "spring.kafka.global.embedded.enabled";
    public static final String COUNT_PROPERTY_NAME = "spring.kafka.embedded.count";
    public static final String PORTS_PROPERTY_NAME = "spring.kafka.embedded.ports";
    public static final String TOPICS_PROPERTY_NAME = "spring.kafka.embedded.topics";
    public static final String PARTITIONS_PROPERTY_NAME = "spring.kafka.embedded.partitions";
    public static final String KRAFT_PROPERTY_NAME = "spring.kafka.embedded.kraft";
    public static final String BROKER_PROPERTIES_LOCATION_PROPERTY_NAME = "spring.kafka.embedded.broker.properties.location";
    private EmbeddedKafkaBroker embeddedKafkaBroker;
    private Log logger;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.logger = LogFactory.getLog(GlobalEmbeddedKafkaTestExecutionListener.class);
        try {
            TestPlan.class.getDeclaredMethod("getConfigurationParameters", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            this.logger.debug((Object)"JUnit Platform version must be >= 1.8 to use a global embedded kafka server");
            return;
        }
        ConfigurationParameters configurationParameters = testPlan.getConfigurationParameters();
        boolean enabled = configurationParameters.getBoolean(LISTENER_ENABLED_PROPERTY_NAME).orElse(false);
        if (enabled) {
            Integer count = configurationParameters.get(COUNT_PROPERTY_NAME, Integer::parseInt).orElse(1);
            String[] topics = configurationParameters.get(TOPICS_PROPERTY_NAME, StringUtils::commaDelimitedListToStringArray).orElse(null);
            Integer partitions = configurationParameters.get(PARTITIONS_PROPERTY_NAME, Integer::parseInt).orElse(2);
            Map<String, String> brokerProperties = configurationParameters.get(BROKER_PROPERTIES_LOCATION_PROPERTY_NAME, this::brokerProperties).orElse(Map.of());
            String brokerListProperty = configurationParameters.get("spring.embedded.kafka.brokers.property").orElse(null);
            int[] ports = configurationParameters.get(PORTS_PROPERTY_NAME, this::ports).orElse(new int[count.intValue()]);
            boolean kraft = configurationParameters.getBoolean(KRAFT_PROPERTY_NAME).orElse(true);
            this.embeddedKafkaBroker = kraft ? new EmbeddedKafkaKraftBroker(count, partitions, topics).brokerProperties(brokerProperties).kafkaPorts(ports) : new EmbeddedKafkaZKBroker((int)count, false, partitions, topics).brokerProperties(brokerProperties).kafkaPorts(ports);
            if (brokerListProperty != null) {
                this.embeddedKafkaBroker.brokerListProperty(brokerListProperty);
            }
            this.embeddedKafkaBroker.afterPropertiesSet();
            this.logger.info((Object)("Started global Embedded Kafka on: " + this.embeddedKafkaBroker.getBrokersAsString()));
        }
    }

    private Map<String, String> brokerProperties(String propertiesLocation) {
        Resource propertiesResource = new DefaultResourceLoader().getResource(propertiesLocation);
        try {
            return PropertiesLoaderUtils.loadProperties((Resource)propertiesResource);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private int[] ports(String ports) {
        return StringUtils.commaDelimitedListToSet((String)ports).stream().mapToInt(Integer::parseInt).toArray();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.embeddedKafkaBroker.destroy();
        this.logger.info((Object)"Stopped global Embedded Kafka.");
    }
}

