/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class EmbeddedKafkaContextCustomizer
implements ContextCustomizer {
    private final EmbeddedKafka embeddedKafka;

    EmbeddedKafkaContextCustomizer(EmbeddedKafka embeddedKafka) {
        this.embeddedKafka = embeddedKafka;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(DefaultSingletonBeanRegistry.class, (Object)beanFactory);
        ConfigurableEnvironment environment = context.getEnvironment();
        String[] topics = (String[])Arrays.stream(this.embeddedKafka.topics()).map(arg_0 -> ((ConfigurableEnvironment)environment).resolvePlaceholders(arg_0)).toArray(String[]::new);
        int[] ports = this.setupPorts();
        EmbeddedKafkaBroker embeddedKafkaBroker = new EmbeddedKafkaBroker(this.embeddedKafka.count(), this.embeddedKafka.controlledShutdown(), this.embeddedKafka.partitions(), topics).kafkaPorts(ports).zkPort(this.embeddedKafka.zookeeperPort()).zkConnectionTimeout(this.embeddedKafka.zkConnectionTimeout()).zkSessionTimeout(this.embeddedKafka.zkSessionTimeout());
        Properties properties = new Properties();
        for (String pair : this.embeddedKafka.brokerProperties()) {
            if (!StringUtils.hasText((String)pair)) continue;
            try {
                properties.load(new StringReader(environment.resolvePlaceholders(pair)));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load broker property from [" + pair + "]", ex);
            }
        }
        if (StringUtils.hasText((String)this.embeddedKafka.brokerPropertiesLocation())) {
            String propertiesLocation = environment.resolvePlaceholders(this.embeddedKafka.brokerPropertiesLocation());
            Resource propertiesResource = context.getResource(propertiesLocation);
            if (!propertiesResource.exists()) {
                throw new IllegalStateException("Failed to load broker properties from [" + propertiesResource + "]: resource does not exist.");
            }
            try (InputStream in = propertiesResource.getInputStream();){
                Properties p = new Properties();
                p.load(in);
                p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.putIfAbsent(key, environment.resolvePlaceholders((String)value))));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load broker properties from [" + propertiesResource + "]", ex);
            }
        }
        embeddedKafkaBroker.brokerProperties(properties);
        if (StringUtils.hasText((String)this.embeddedKafka.bootstrapServersProperty())) {
            embeddedKafkaBroker.brokerListProperty(this.embeddedKafka.bootstrapServersProperty());
        }
        beanFactory.initializeBean((Object)embeddedKafkaBroker, "embeddedKafka");
        beanFactory.registerSingleton("embeddedKafka", (Object)embeddedKafkaBroker);
        ((DefaultSingletonBeanRegistry)beanFactory).registerDisposableBean("embeddedKafka", (DisposableBean)embeddedKafkaBroker);
    }

    private int[] setupPorts() {
        int[] ports = this.embeddedKafka.ports();
        if (this.embeddedKafka.count() > 1 && ports.length == 1 && ports[0] == 0) {
            ports = new int[this.embeddedKafka.count()];
        }
        return ports;
    }

    public int hashCode() {
        return this.embeddedKafka.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EmbeddedKafkaContextCustomizer customizer = (EmbeddedKafkaContextCustomizer)obj;
        return this.embeddedKafka.equals(customizer.embeddedKafka);
    }
}

