/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.leader;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.recipes.leader.Participant;
import org.jspecify.annotations.Nullable;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.event.LeaderEventPublisher;

public class LeaderInitiator
implements SmartLifecycle {
    private static final Log LOGGER = LogFactory.getLog(LeaderInitiator.class);
    private static final String DEFAULT_NAMESPACE = "/spring-integration/leader/";
    private final CuratorContext context = new CuratorContext();
    private final CuratorContext nullContext = new NullCuratorContext();
    private final CuratorFramework client;
    private final Candidate candidate;
    private final Lock lifecycleMonitor = new ReentrantLock();
    private final String namespace;
    private @Nullable LeaderEventPublisher leaderEventPublisher;
    private boolean autoStartup = true;
    private int phase = 2147482647;
    private volatile @Nullable LeaderSelector leaderSelector;
    private volatile boolean running;

    public LeaderInitiator(CuratorFramework client, Candidate candidate) {
        this(client, candidate, DEFAULT_NAMESPACE);
    }

    public LeaderInitiator(CuratorFramework client, Candidate candidate, String namespace) {
        this.client = client;
        this.candidate = candidate;
        this.namespace = namespace;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void start() {
        this.lifecycleMonitor.lock();
        try {
            if (!this.running) {
                if (this.client.getState() != CuratorFrameworkState.STARTED) {
                    this.client.start();
                }
                LeaderSelector leaderSelectorToSet = new LeaderSelector(this.client, this.buildLeaderPath(), (LeaderSelectorListener)new LeaderListener());
                leaderSelectorToSet.setId(this.candidate.getId());
                leaderSelectorToSet.autoRequeue();
                leaderSelectorToSet.start();
                this.leaderSelector = leaderSelectorToSet;
                this.running = true;
                LOGGER.debug((Object)"Started LeaderInitiator");
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    public void stop() {
        this.lifecycleMonitor.lock();
        try {
            if (this.running) {
                LeaderSelector leaderSelectorToClose = this.leaderSelector;
                if (leaderSelectorToClose != null) {
                    leaderSelectorToClose.close();
                }
                this.running = false;
                LOGGER.debug((Object)"Stopped LeaderInitiator");
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        this.leaderEventPublisher = leaderEventPublisher;
    }

    public CuratorContext getContext() {
        if (this.leaderSelector == null) {
            return this.nullContext;
        }
        return this.context;
    }

    private String buildLeaderPath() {
        Object ns = this.namespace;
        if (((String)ns).charAt(0) != '/') {
            ns = "/" + (String)ns;
        }
        if (!((String)ns).endsWith("/")) {
            ns = (String)ns + "/";
        }
        return (String)ns + this.candidate.getRole();
    }

    public class CuratorContext
    implements Context {
        CuratorContext() {
        }

        public boolean isLeader() {
            LeaderSelector leaderSelectorToCheck = LeaderInitiator.this.leaderSelector;
            return leaderSelectorToCheck != null && leaderSelectorToCheck.hasLeadership();
        }

        public void yield() {
            LeaderSelector leaderSelectorToInterrupt = LeaderInitiator.this.leaderSelector;
            if (leaderSelectorToInterrupt != null) {
                leaderSelectorToInterrupt.interruptLeadership();
            }
        }

        public String getRole() {
            return LeaderInitiator.this.candidate.getRole();
        }

        public @Nullable Participant getLeader() {
            LeaderSelector leaderSelectorToUse = LeaderInitiator.this.leaderSelector;
            if (leaderSelectorToUse != null) {
                try {
                    return leaderSelectorToUse.getLeader();
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return null;
        }

        public Collection<Participant> getParticipants() {
            LeaderSelector leaderSelectorToUse = LeaderInitiator.this.leaderSelector;
            if (leaderSelectorToUse != null) {
                try {
                    return leaderSelectorToUse.getParticipants();
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return List.of();
        }

        public String toString() {
            return "CuratorContext{role=" + LeaderInitiator.this.candidate.getRole() + ", id=" + LeaderInitiator.this.candidate.getId() + ", isLeader=" + this.isLeader() + "}";
        }
    }

    private final class NullCuratorContext
    extends CuratorContext {
        private NullCuratorContext() {
        }

        @Override
        public boolean isLeader() {
            return false;
        }

        @Override
        public @Nullable Participant getLeader() {
            return null;
        }

        @Override
        public Collection<Participant> getParticipants() {
            return List.of();
        }
    }

    protected class LeaderListener
    extends LeaderSelectorListenerAdapter {
        protected LeaderListener() {
        }

        public void takeLeadership(CuratorFramework framework) {
            try {
                LeaderInitiator.this.candidate.onGranted((Context)LeaderInitiator.this.context);
                if (LeaderInitiator.this.leaderEventPublisher != null) {
                    try {
                        LeaderInitiator.this.leaderEventPublisher.publishOnGranted((Object)LeaderInitiator.this, (Context)LeaderInitiator.this.context, LeaderInitiator.this.candidate.getRole());
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Error publishing OnGranted event.", (Throwable)e);
                    }
                }
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {
            }
            finally {
                LeaderInitiator.this.candidate.onRevoked((Context)LeaderInitiator.this.context);
                if (LeaderInitiator.this.leaderEventPublisher != null) {
                    try {
                        LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)LeaderInitiator.this.context, LeaderInitiator.this.candidate.getRole());
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Error publishing OnRevoked event.", (Throwable)e);
                    }
                }
            }
        }
    }
}

