/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.config;

import java.io.Closeable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class CuratorFrameworkFactoryBean
implements FactoryBean<CuratorFramework>,
SmartLifecycle {
    private final Lock lifecycleLock = new ReentrantLock();
    private final CuratorFramework client;
    private boolean autoStartup = true;
    private int phase = -2147482648;
    private volatile boolean running;

    public CuratorFrameworkFactoryBean(String connectionString) {
        this(connectionString, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
    }

    public CuratorFrameworkFactoryBean(String connectionString, RetryPolicy retryPolicy) {
        Assert.notNull((Object)connectionString, (String)"'connectionString' cannot be null");
        Assert.notNull((Object)retryPolicy, (String)"'retryPolicy' cannot be null");
        this.client = CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)retryPolicy);
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.client.start();
                this.running = true;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                CloseableUtils.closeQuietly((Closeable)this.client);
                this.running = false;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public CuratorFramework getObject() {
        return this.client;
    }

    public Class<?> getObjectType() {
        return CuratorFramework.class;
    }
}

