/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.transformer;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.zip.transformer.AbstractZipTransformer;
import org.springframework.integration.zip.transformer.SpringZipUtils;
import org.springframework.integration.zip.transformer.ZipResultType;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipEntrySource;

public class ZipTransformer
extends AbstractZipTransformer {
    private static final String ZIP_EXTENSION = ".zip";
    private int compressionLevel = -1;
    private boolean useFileAttributes = true;
    private FileNameGenerator fileNameGenerator;

    public void setCompressionLevel(int compressionLevel) {
        Assert.isTrue((compressionLevel >= 0 && compressionLevel <= 9 ? 1 : 0) != 0, (String)"Acceptable levels are 0-9");
        this.compressionLevel = compressionLevel;
    }

    public void setUseFileAttributes(boolean useFileAttributes) {
        this.useFileAttributes = useFileAttributes;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"'fileNameGenerator' must not be null");
        this.fileNameGenerator = fileNameGenerator;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.fileNameGenerator == null) {
            DefaultFileNameGenerator defaultFileNameGenerator = new DefaultFileNameGenerator();
            defaultFileNameGenerator.setBeanFactory(this.getBeanFactory());
            defaultFileNameGenerator.setConversionService(this.getConversionService());
            this.fileNameGenerator = defaultFileNameGenerator;
        }
    }

    @Override
    protected Object doZipTransform(Message<?> message) {
        Object zippedData;
        Object payload = message.getPayload();
        MessageHeaders messageHeaders = message.getHeaders();
        String baseFileName = this.fileNameGenerator.generateFileName(message);
        Object zipFileName = baseFileName.endsWith(ZIP_EXTENSION) ? baseFileName : baseFileName + ZIP_EXTENSION;
        String zipEntryName = (String)messageHeaders.getOrDefault((Object)"zip_entryFilename", (Object)baseFileName);
        Date lastModifiedDate = (Date)messageHeaders.getOrDefault((Object)"zip_entryLastModifiedDate", (Object)new Date());
        List<ZipEntrySource> entries = this.createZipEntries(payload, zipEntryName, lastModifiedDate);
        byte[] zippedBytes = SpringZipUtils.pack(entries, this.compressionLevel);
        if (ZipResultType.FILE.equals((Object)this.zipResultType)) {
            File zippedFile = new File(this.workDirectory, (String)zipFileName);
            try {
                FileCopyUtils.copy((byte[])zippedBytes, (File)zippedFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            zippedData = zippedFile;
        } else if (ZipResultType.BYTE_ARRAY.equals((Object)this.zipResultType)) {
            zippedData = zippedBytes;
        } else {
            throw new IllegalStateException("Unsupported zipResultType " + String.valueOf((Object)this.zipResultType));
        }
        this.deleteFilesIfAny(payload);
        return this.getMessageBuilderFactory().withPayload(zippedData).copyHeaders((Map)messageHeaders).setHeader("file_name", zipFileName).build();
    }

    private List<ZipEntrySource> createZipEntries(Object payload, String zipEntryName, Date lastModifiedDate) {
        ArrayList<ZipEntrySource> entries = new ArrayList<ZipEntrySource>();
        if (payload instanceof Iterable) {
            int counter = 1;
            String baseName = FilenameUtils.getBaseName((String)zipEntryName);
            Object fileExtension = FilenameUtils.getExtension((String)zipEntryName);
            if (StringUtils.hasText((String)fileExtension)) {
                fileExtension = FilenameUtils.EXTENSION_SEPARATOR_STR + (String)fileExtension;
            }
            for (Object item : (Iterable)payload) {
                ZipEntrySource zipEntrySource = this.createZipEntrySource(item, lastModifiedDate, baseName + "_" + counter + (String)fileExtension, this.useFileAttributes);
                this.logger.debug(() -> "ZipEntrySource path: '" + zipEntrySource.getPath() + "'");
                entries.add(zipEntrySource);
                ++counter;
            }
        } else {
            ZipEntrySource zipEntrySource = this.createZipEntrySource(payload, lastModifiedDate, zipEntryName, this.useFileAttributes);
            entries.add(zipEntrySource);
        }
        return entries;
    }

    private void deleteFilesIfAny(Object payload) {
        if (this.deleteFiles) {
            if (payload instanceof Iterable) {
                for (Object item : (Iterable)payload) {
                    this.deleteFile(item);
                }
            } else {
                this.deleteFile(payload);
            }
        }
    }

    private void deleteFile(Object fileToDelete) {
        if (fileToDelete instanceof File && !((File)fileToDelete).delete()) {
            this.logger.warn(() -> "Failed to delete File '" + String.valueOf(fileToDelete) + "'");
        }
    }

    private ZipEntrySource createZipEntrySource(Object item, Date lastModifiedDate, String zipEntryName, boolean useFileAttributes) {
        if (item instanceof File) {
            String fileName;
            File filePayload = (File)item;
            String string = fileName = useFileAttributes ? filePayload.getName() : zipEntryName;
            if (filePayload.isDirectory()) {
                throw new UnsupportedOperationException("Zipping of directories is not supported.");
            }
            return new FileSource(fileName, filePayload);
        }
        if (item instanceof byte[] || item instanceof String) {
            byte[] byArray;
            if (item instanceof String) {
                String stringItem = (String)item;
                byArray = stringItem.getBytes(this.charset);
            } else {
                byArray = (byte[])item;
            }
            byte[] bytesToCompress = byArray;
            return new ByteSource(zipEntryName, bytesToCompress, lastModifiedDate.getTime());
        }
        throw new IllegalArgumentException("Unsupported payload type. The only supported payloads are java.io.File, java.lang.String, and byte[]");
    }
}

