/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zeromq;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import zmq.ZMQ;

public class ZeroMqProxy
implements InitializingBean,
SmartLifecycle,
BeanNameAware,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(ZeroMqProxy.class);
    private final Lock lock = new ReentrantLock();
    private final ZContext context;
    private final Type type;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicInteger frontendPort = new AtomicInteger();
    private final AtomicInteger backendPort = new AtomicInteger();
    private String controlAddress;
    private Executor proxyExecutor;
    @Nullable
    private Consumer<ZMQ.Socket> frontendSocketConfigurer;
    @Nullable
    private Consumer<ZMQ.Socket> backendSocketConfigurer;
    private boolean exposeCaptureSocket;
    @Nullable
    private String captureAddress;
    private String beanName;
    private boolean autoStartup = true;
    private int phase;

    public ZeroMqProxy(ZContext context) {
        this(context, Type.PULL_PUSH);
    }

    public ZeroMqProxy(ZContext context, Type type) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        Assert.notNull((Object)((Object)type), (String)"'type' must not be null");
        this.context = context;
        this.type = type;
    }

    public void setProxyExecutor(Executor proxyExecutor) {
        Assert.notNull((Object)proxyExecutor, (String)"'proxyExecutor' must not be null");
        this.proxyExecutor = proxyExecutor;
    }

    public void setFrontendPort(int frontendPort) {
        Assert.isTrue((frontendPort > 0 ? 1 : 0) != 0, (String)"'frontendPort' must not be zero or negative");
        this.frontendPort.set(frontendPort);
    }

    public void setBackendPort(int backendPort) {
        Assert.isTrue((backendPort > 0 ? 1 : 0) != 0, (String)"'backendPort' must not be zero or negative");
        this.backendPort.set(backendPort);
    }

    public void setFrontendSocketConfigurer(@Nullable Consumer<ZMQ.Socket> frontendSocketConfigurer) {
        this.frontendSocketConfigurer = frontendSocketConfigurer;
    }

    public void setBackendSocketConfigurer(@Nullable Consumer<ZMQ.Socket> backendSocketConfigurer) {
        this.backendSocketConfigurer = backendSocketConfigurer;
    }

    public void setExposeCaptureSocket(boolean exposeCaptureSocket) {
        this.exposeCaptureSocket = exposeCaptureSocket;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public Type getType() {
        return this.type;
    }

    public int getFrontendPort() {
        return this.frontendPort.get();
    }

    public int getBackendPort() {
        return this.backendPort.get();
    }

    @Nullable
    public String getControlAddress() {
        return this.controlAddress;
    }

    @Nullable
    public String getCaptureAddress() {
        return this.captureAddress;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return this.phase;
    }

    public void afterPropertiesSet() {
        if (this.proxyExecutor == null) {
            this.proxyExecutor = new SimpleAsyncTaskExecutor(this.beanName + "-");
        }
        this.controlAddress = "inproc://" + this.beanName + ".control";
        if (this.exposeCaptureSocket) {
            this.captureAddress = "inproc://" + this.beanName + ".capture";
        }
    }

    public void start() {
        this.lock.lock();
        try {
            if (!this.running.get()) {
                this.proxyExecutor.execute(() -> {
                    ZMQ.Socket captureSocket = null;
                    if (this.exposeCaptureSocket) {
                        captureSocket = this.context.createSocket(SocketType.PUB);
                    }
                    try (ZMQ.Socket frontendSocket = this.context.createSocket(this.type.getFrontendSocketType());
                         ZMQ.Socket backendSocket = this.context.createSocket(this.type.getBackendSocketType());
                         ZMQ.Socket controlSocket = this.context.createSocket(SocketType.PAIR);){
                        if (this.frontendSocketConfigurer != null) {
                            this.frontendSocketConfigurer.accept(frontendSocket);
                        }
                        if (this.backendSocketConfigurer != null) {
                            this.backendSocketConfigurer.accept(backendSocket);
                        }
                        this.frontendPort.set(ZeroMqProxy.bindSocket(frontendSocket, this.frontendPort.get()));
                        this.backendPort.set(ZeroMqProxy.bindSocket(backendSocket, this.backendPort.get()));
                        boolean bound = controlSocket.bind(this.controlAddress);
                        if (!bound) {
                            throw new IllegalArgumentException("Cannot bind ZeroMQ socket to address: " + this.controlAddress);
                        }
                        if (captureSocket != null && !(bound = captureSocket.bind(this.captureAddress))) {
                            throw new IllegalArgumentException("Cannot bind ZeroMQ socket to address: " + this.captureAddress);
                        }
                        this.running.set(true);
                        org.zeromq.ZMQ.proxy((ZMQ.Socket)frontendSocket, (ZMQ.Socket)backendSocket, (ZMQ.Socket)captureSocket, (ZMQ.Socket)controlSocket);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Cannot start ZeroMQ proxy from bean: " + this.beanName), (Throwable)ex);
                    }
                    finally {
                        if (captureSocket != null) {
                            captureSocket.close();
                        }
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block9: {
            this.lock.lock();
            try {
                if (!this.running.getAndSet(false)) break block9;
                try (ZMQ.Socket commandSocket = this.context.createSocket(SocketType.PAIR);){
                    commandSocket.connect(this.controlAddress);
                    commandSocket.send(ZMQ.PROXY_TERMINATE);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void destroy() {
        this.stop();
    }

    private static int bindSocket(ZMQ.Socket socket, int port) {
        if (port == 0) {
            return socket.bindToRandomPort("tcp://*");
        }
        boolean bound = socket.bind("tcp://*:" + port);
        if (!bound) {
            throw new IllegalArgumentException("Cannot bind ZeroMQ socket to port: " + port);
        }
        return port;
    }

    public static enum Type {
        SUB_PUB(SocketType.XSUB, SocketType.XPUB),
        PULL_PUSH(SocketType.PULL, SocketType.PUSH),
        ROUTER_DEALER(SocketType.ROUTER, SocketType.DEALER);

        private final SocketType frontendSocketType;
        private final SocketType backendSocketType;

        private Type(SocketType frontendSocketType, SocketType backendSocketType) {
            this.frontendSocketType = frontendSocketType;
            this.backendSocketType = backendSocketType;
        }

        public SocketType getFrontendSocketType() {
            return this.frontendSocketType;
        }

        public SocketType getBackendSocketType() {
            return this.backendSocketType;
        }
    }
}

