/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;
import org.jspecify.annotations.Nullable;
import org.jxmpp.jid.Jid;
import org.jxmpp.stringprep.XmppStringprepException;
import org.springframework.integration.mapping.AbstractHeaderMapper;
import org.springframework.integration.xmpp.support.XmppHeaderMapper;
import org.springframework.util.StringUtils;

public class DefaultXmppHeaderMapper
extends AbstractHeaderMapper<MessageBuilder>
implements XmppHeaderMapper {
    private static final List<String> STANDARD_HEADER_NAMES = new ArrayList<String>();

    public DefaultXmppHeaderMapper() {
        super("xmpp_", STANDARD_HEADER_NAMES, STANDARD_HEADER_NAMES);
    }

    protected Map<String, @Nullable Object> extractStandardHeaders(MessageBuilder source) {
        Message.Type type;
        Jid to;
        String thread;
        String subject;
        HashMap<String, @Nullable Object> headers = new HashMap<String, Object>();
        Jid from = source.getFrom();
        if (from != null) {
            headers.put("xmpp_from", from.toString());
        }
        if (StringUtils.hasText((String)(subject = source.getSubject()))) {
            headers.put("xmpp_subject", subject);
        }
        if (StringUtils.hasText((String)(thread = source.getThread()))) {
            headers.put("xmpp_thread", thread);
        }
        if ((to = source.getTo()) != null) {
            headers.put("xmpp_to", to.toString());
        }
        if ((type = source.getType()) != null) {
            headers.put("xmpp_type", type);
        }
        return headers;
    }

    protected Map<String, @Nullable Object> extractUserDefinedHeaders(MessageBuilder source) {
        HashMap<String, @Nullable Object> headers = new HashMap<String, Object>();
        JivePropertiesExtension jpe = JivePropertiesExtension.from((Message)source.build());
        if (jpe == null) {
            return headers;
        }
        for (String propertyName : jpe.getPropertyNames()) {
            headers.put(propertyName, JivePropertiesManager.getProperty((StanzaView)source, (String)propertyName));
        }
        return headers;
    }

    protected void populateStandardHeaders(Map<String, Object> headers, MessageBuilder target) {
        Object typeHeader;
        String threadId = (String)this.getHeaderIfAvailable(headers, "xmpp_thread", String.class);
        if (StringUtils.hasText((String)threadId)) {
            target.setThread(threadId);
        }
        this.populateToHeader(headers, target);
        this.populateFromHeader(headers, target);
        String subject = (String)this.getHeaderIfAvailable(headers, "xmpp_subject", String.class);
        if (StringUtils.hasText((String)subject)) {
            target.setSubject(subject);
        }
        if ((typeHeader = this.getHeaderIfAvailable(headers, "xmpp_type", Object.class)) instanceof String) {
            try {
                typeHeader = Message.Type.valueOf((String)((String)typeHeader));
            }
            catch (Exception e) {
                this.logger.warn((Object)"XMPP Type must be either a valid [Message.Type] enum value or a String representation of such.");
            }
        }
        if (typeHeader instanceof Message.Type) {
            Message.Type messageType = (Message.Type)typeHeader;
            target.ofType(messageType);
        }
    }

    private void populateToHeader(Map<String, Object> headers, MessageBuilder target) {
        String to = (String)this.getHeaderIfAvailable(headers, "xmpp_to", String.class);
        if (StringUtils.hasText((String)to)) {
            try {
                target.to((CharSequence)to);
            }
            catch (XmppStringprepException e) {
                throw new IllegalStateException("Cannot parse 'xmpp_to' header value", e);
            }
        }
    }

    private void populateFromHeader(Map<String, Object> headers, MessageBuilder target) {
        String from = (String)this.getHeaderIfAvailable(headers, "xmpp_from", String.class);
        if (StringUtils.hasText((String)from)) {
            try {
                target.from((CharSequence)from);
            }
            catch (XmppStringprepException e) {
                throw new IllegalStateException("Cannot parse 'xmpp_from' header value", e);
            }
        }
    }

    protected void populateUserDefinedHeader(String headerName, Object headerValue, MessageBuilder target) {
        JivePropertiesManager.addProperty((StanzaBuilder)target, (String)headerName, (Object)headerValue);
    }

    static {
        STANDARD_HEADER_NAMES.add("xmpp_from");
        STANDARD_HEADER_NAMES.add("xmpp_subject");
        STANDARD_HEADER_NAMES.add("xmpp_thread");
        STANDARD_HEADER_NAMES.add("xmpp_to");
        STANDARD_HEADER_NAMES.add("xmpp_type");
    }
}

