/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.outbound;

import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;

public class PresenceSendingMessageHandler
extends AbstractXmppConnectionAwareMessageHandler {
    public PresenceSendingMessageHandler() {
    }

    public PresenceSendingMessageHandler(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public String getComponentType() {
        return "xmpp:presence-outbound-channel-adapter";
    }

    protected void handleMessageInternal(Message<?> message) {
        Assert.state((boolean)this.isInitialized(), () -> this.getComponentName() + " must be initialized");
        Object payload = message.getPayload();
        Assert.state((boolean)(payload instanceof Presence), () -> "Payload must be of type 'org.jivesoftware.smack.packet.Presence', was: " + payload.getClass().getName());
        try {
            XMPPConnection xmppConnection = this.getXmppConnection();
            if (!xmppConnection.isConnected() && xmppConnection instanceof AbstractXMPPConnection) {
                ((AbstractXMPPConnection)xmppConnection).connect();
            }
            xmppConnection.sendStanza((Stanza)((Presence)payload));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessageHandlingException(message, "Thread interrupted in the [" + (Object)((Object)this) + ']', (Throwable)e);
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "Failed to handle message in the [" + (Object)((Object)this) + ']', (Throwable)e);
        }
    }
}

