/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class EventuallyMatcher<U>
extends DiagnosingMatcher<U> {
    private final Matcher<U> delegate;
    private int nbAttempts;
    private int pause;

    public EventuallyMatcher(Matcher<U> delegate) {
        this(delegate, 20, 100);
    }

    public EventuallyMatcher(Matcher<U> delegate, int nbAttempts, int pause) {
        this.delegate = delegate;
        this.nbAttempts = nbAttempts;
        this.pause = pause;
    }

    @Factory
    public static <U> Matcher<U> eventually(int nbAttempts, int pause, Matcher<U> delegate) {
        return new EventuallyMatcher<U>(delegate, nbAttempts, pause);
    }

    @Factory
    public static <U> Matcher<U> eventually(Matcher<U> delegate) {
        return new EventuallyMatcher<U>(delegate);
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.delegate).appendText(String.format(", trying at most %d times", this.nbAttempts));
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        mismatchDescription.appendText(String.format("failed after %d*%d=%dms:%n", this.nbAttempts, this.pause, this.nbAttempts * this.pause));
        for (int i = 0; i < this.nbAttempts; ++i) {
            boolean result = this.delegate.matches(item);
            if (result) {
                return true;
            }
            this.delegate.describeMismatch(item, mismatchDescription);
            mismatchDescription.appendText(", ");
            try {
                Thread.sleep(this.pause);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return false;
    }
}

