/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Factory;
import org.springframework.util.ObjectUtils;

public class EqualsResultMatcher<U>
extends DiagnosingMatcher<U> {
    private final Supplier<U> supplier;

    public EqualsResultMatcher(Supplier<U> supplier) {
        this.supplier = supplier;
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        return ObjectUtils.nullSafeEquals((Object)item, this.supplier.get());
    }

    public void describeTo(Description description) {
    }

    @Factory
    public static <U> EqualsResultMatcher<U> equalsResult(Supplier<U> supplier) {
        return new EqualsResultMatcher<U>(supplier);
    }
}

