/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.springframework.messaging.Message;

public class PayloadMatcher<T>
extends TypeSafeMatcher<Message<?>> {
    private final Matcher<T> matcher;

    private PayloadMatcher(Matcher<T> matcher) {
        this.matcher = matcher;
    }

    public boolean matchesSafely(Message<?> message) {
        return this.matcher.matches(message.getPayload());
    }

    public void describeTo(Description description) {
        description.appendText("a Message with payload: ").appendDescriptionOf(this.matcher);
    }

    @Factory
    public static <P> PayloadMatcher<P> hasPayload(P payload) {
        return new PayloadMatcher(IsEqual.equalTo(payload));
    }

    @Factory
    public static <P> PayloadMatcher<P> hasPayload(Matcher<P> payloadMatcher) {
        return new PayloadMatcher<P>(payloadMatcher);
    }
}

