/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog;

import java.util.Map;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.syslog.DefaultMessageConverter;
import org.springframework.integration.syslog.RFC5424SyslogParser;
import org.springframework.integration.syslog.SyslogHeaders;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class RFC5424MessageConverter
extends DefaultMessageConverter {
    private final RFC5424SyslogParser parser;
    private String charset = "UTF-8";

    public RFC5424MessageConverter() {
        this(new RFC5424SyslogParser());
    }

    public RFC5424MessageConverter(RFC5424SyslogParser parser) {
        this.parser = parser;
    }

    protected void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public Message<?> fromSyslog(Message<?> message) throws Exception {
        Object originalContent;
        Map<String, ?> map;
        boolean isMap = message.getPayload() instanceof Map;
        if (!isMap) {
            Assert.isInstanceOf(byte[].class, (Object)message.getPayload(), (String)"Only byte[] and Map payloads are supported");
            map = this.parser.parse(new String((byte[])message.getPayload(), this.charset), 0, false);
            originalContent = message.getPayload();
        } else {
            map = (Map<String, ?>)message.getPayload();
            originalContent = map.get(SyslogHeaders.UNDECODED);
            if (originalContent == null) {
                originalContent = map;
            }
        }
        AbstractIntegrationMessageBuilder builder = this.getMessageBuilderFactory().withPayload((Object)(this.asMap() ? map : originalContent)).copyHeaders((Map)message.getHeaders());
        if (!this.asMap() && isMap) {
            builder.copyHeaders(map);
        }
        return builder.build();
    }
}

