/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.integration.syslog.inbound.SyslogReceivingChannelAdapterSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class UdpSyslogReceivingChannelAdapter
extends SyslogReceivingChannelAdapterSupport {
    private volatile UnicastReceivingChannelAdapter udpAdapter;

    public void setUdpAdapter(UnicastReceivingChannelAdapter udpAdpter) {
        this.udpAdapter = udpAdpter;
    }

    public String getComponentType() {
        return "syslog:inbound-channel-adapter(udp)";
    }

    @Override
    protected void onInit() {
        if (this.udpAdapter == null) {
            this.udpAdapter = new UnicastReceivingChannelAdapter(this.getPort());
        }
        DirectChannel outputChannel = new DirectChannel();
        outputChannel.subscribe(new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                UdpSyslogReceivingChannelAdapter.this.convertAndSend(message);
            }
        });
        this.udpAdapter.setOutputChannel((MessageChannel)outputChannel);
    }

    protected void doStart() {
        super.doStart();
        this.udpAdapter.start();
    }

    protected void doStop() {
        super.doStop();
        this.udpAdapter.stop();
    }
}

