/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.syslog.DefaultMessageConverter;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;

public abstract class SyslogReceivingChannelAdapterSupport
extends MessageProducerSupport {
    protected static final int DEFAULT_PORT = 514;
    private volatile int port = 514;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile MessageConverter converter = new DefaultMessageConverter();
    private volatile boolean converterSet;

    protected int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConverter(MessageConverter converter) {
        this.converter = converter;
        this.converterSet = true;
    }

    protected void onInit() {
        super.onInit();
        if (!this.converterSet) {
            ((DefaultMessageConverter)this.converter).setBeanFactory(this.getBeanFactory());
        }
    }

    protected void convertAndSend(Message<?> message) {
        try {
            if (message instanceof ErrorMessage) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Error on syslog socket:" + ((Throwable)((ErrorMessage)message).getPayload()).getMessage()));
                }
            } else {
                this.sendMessage(this.converter.fromSyslog(message));
            }
        }
        catch (Exception e) {
            throw new MessagingException(message, (Throwable)e);
        }
    }
}

