/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.integration.syslog.SyslogHeaders;
import org.springframework.integration.transformer.SyslogToMapTransformer;
import org.springframework.messaging.Message;

public class DefaultMessageConverter
implements MessageConverter,
BeanFactoryAware {
    private final SyslogToMapTransformer transformer = new SyslogToMapTransformer();
    public static final Set<String> SYSLOG_PAYLOAD_ENTRIES = new HashSet<String>(Arrays.asList("MESSAGE", "UNDECODED"));
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean asMap = true;

    public void setAsMap(boolean asMap) {
        this.asMap = asMap;
    }

    protected boolean asMap() {
        return this.asMap;
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)beanFactory);
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    @Override
    public Message<?> fromSyslog(Message<?> message) throws Exception {
        Map map = (Map)this.transformer.doTransform(message);
        HashMap out = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (SYSLOG_PAYLOAD_ENTRIES.contains(key)) continue;
            out.put(SyslogHeaders.PREFIX + (String)entry.getKey(), entry.getValue());
        }
        return this.messageBuilderFactory.withPayload(this.asMap ? map : message.getPayload()).copyHeaders(out).build();
    }
}

