/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp;

import org.springframework.integration.stomp.AbstractStompSessionManager;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.messaging.WebSocketStompClient;

public class WebSocketStompSessionManager
extends AbstractStompSessionManager {
    private final String url;
    private final Object[] uriVariables;
    private volatile WebSocketHttpHeaders handshakeHeaders;

    public WebSocketStompSessionManager(WebSocketStompClient webSocketStompClient, String url, Object ... uriVariables) {
        super((StompClientSupport)webSocketStompClient);
        Assert.hasText((String)url, (String)"'url' must not be empty.");
        this.url = url;
        this.uriVariables = uriVariables;
    }

    public void setHandshakeHeaders(WebSocketHttpHeaders handshakeHeaders) {
        this.handshakeHeaders = handshakeHeaders;
    }

    @Override
    protected ListenableFuture<StompSession> doConnect(StompSessionHandler handler) {
        return ((WebSocketStompClient)this.stompClient).connect(this.url, this.handshakeHeaders, this.getConnectHeaders(), handler, this.uriVariables);
    }
}

