/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.inbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.smb.filters.SmbPersistentAcceptOnceFileListFilter;
import org.springframework.integration.smb.session.SmbFileInfo;

public class SmbStreamingMessageSource
extends AbstractRemoteFileStreamingMessageSource<SmbFile> {
    public SmbStreamingMessageSource(RemoteFileTemplate<SmbFile> template) {
        this(template, null);
    }

    public SmbStreamingMessageSource(RemoteFileTemplate<SmbFile> template, @Nullable Comparator<SmbFile> comparator) {
        super(template, comparator);
        this.doSetFilter((FileListFilter)new SmbPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "smbStreamingMessageSource"));
    }

    public String getComponentType() {
        return "smb:inbound-streaming-channel-adapter";
    }

    protected List<AbstractFileInfo<SmbFile>> asFileInfoList(Collection<SmbFile> files) {
        ArrayList<AbstractFileInfo<SmbFile>> canonicalFiles = new ArrayList<AbstractFileInfo<SmbFile>>();
        for (SmbFile file : files) {
            canonicalFiles.add(new SmbFileInfo(file));
        }
        return canonicalFiles;
    }

    protected boolean isDirectory(SmbFile file) {
        try {
            return file.isDirectory();
        }
        catch (SmbException se) {
            this.logger.error((Throwable)se, (CharSequence)"Unable to determine if this SmbFile represents a directory");
            return false;
        }
    }
}

