/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import java.util.List;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.common.SftpException;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.lang.Nullable;

public class SftpRemoteFileTemplate
extends RemoteFileTemplate<SftpClient.DirEntry> {
    protected static final List<Integer> NOT_DIRTY_STATUSES = List.of(2, 10, 20, 9, 11, 18, 19, 1, 22, 24, 28);

    public SftpRemoteFileTemplate(SessionFactory<SftpClient.DirEntry> sessionFactory) {
        super(sessionFactory);
    }

    public <T, C> T executeWithClient(ClientCallback<C, T> callback) {
        return this.doExecuteWithClient(callback);
    }

    protected <T> T doExecuteWithClient(ClientCallback<SftpClient, T> callback) {
        return (T)this.execute(session -> callback.doWithClient((Object)((SftpClient)session.getClientInstance())));
    }

    protected boolean shouldMarkSessionAsDirty(Exception ex) {
        SftpException sftpException = SftpRemoteFileTemplate.findSftpException(ex);
        if (sftpException != null) {
            return this.isStatusDirty(sftpException.getStatus());
        }
        return super.shouldMarkSessionAsDirty(ex);
    }

    protected boolean isStatusDirty(int status) {
        return !NOT_DIRTY_STATUSES.contains(status);
    }

    @Nullable
    private static SftpException findSftpException(Throwable ex) {
        if (ex == null || ex instanceof SftpException) {
            return (SftpException)ex;
        }
        return SftpRemoteFileTemplate.findSftpException(ex.getCause());
    }
}

