/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.RejectAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.io.resource.AbstractIoResource;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpMessage;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.DefaultSftpClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.integration.sftp.session.ResourceKnownHostsServerKeyVerifier;
import org.springframework.integration.sftp.session.SftpSession;
import org.springframework.util.Assert;

public class DefaultSftpSessionFactory
implements SessionFactory<SftpClient.DirEntry>,
SharedSessionCapable,
DisposableBean {
    private final Lock lock = new ReentrantLock();
    private final SshClient sshClient;
    private volatile boolean initialized;
    private final boolean isSharedSession;
    private final Lock sharedSessionLock;
    private boolean isInnerClient = false;
    private String host;
    private int port = 22;
    private String user;
    private String password;
    private HostConfigEntry hostConfig;
    private Resource knownHosts;
    private Resource privateKey;
    private String privateKeyPassphrase;
    private UserInteraction userInteraction;
    private boolean allowUnknownKeys = false;
    private Integer timeout = 30000;
    private SftpVersionSelector sftpVersionSelector = SftpVersionSelector.CURRENT;
    private volatile SftpClient sharedSftpClient;
    private Consumer<SshClient> sshClientConfigurer = sshClient -> {};

    public DefaultSftpSessionFactory() {
        this(false);
    }

    public DefaultSftpSessionFactory(boolean isSharedSession) {
        this(SshClient.setUpDefaultClient(), isSharedSession);
        this.isInnerClient = true;
    }

    public DefaultSftpSessionFactory(SshClient sshClient2, boolean isSharedSession) {
        Assert.notNull((Object)sshClient2, (String)"'sshClient' must not be null");
        this.sshClient = sshClient2;
        this.isSharedSession = isSharedSession;
        this.sharedSessionLock = this.isSharedSession ? new ReentrantLock() : null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        Assert.state((boolean)this.isInnerClient, (String)"A password must be configured on the externally provided SshClient instance");
        this.password = password;
    }

    public void setHostConfig(HostConfigEntry hostConfig) {
        this.hostConfig = hostConfig;
    }

    public void setKnownHostsResource(Resource knownHosts) {
        Assert.state((boolean)this.isInnerClient, (String)"Known hosts must be configured on the externally provided SshClient instance");
        this.knownHosts = knownHosts;
    }

    public void setPrivateKey(Resource privateKey) {
        Assert.state((boolean)this.isInnerClient, (String)"A private key auth must be configured on the externally provided SshClient instance");
        this.privateKey = privateKey;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        Assert.state((boolean)this.isInnerClient, (String)"A private key auth must be configured on the externally provided SshClient instance");
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        Assert.state((boolean)this.isInnerClient, (String)"A `UserInteraction` must be configured on the externally provided SshClient instance");
        this.userInteraction = userInteraction;
    }

    public void setAllowUnknownKeys(boolean allowUnknownKeys) {
        Assert.state((boolean)this.isInnerClient, (String)"An `AcceptAllServerKeyVerifier` must be configured on the externally provided SshClient instance");
        this.allowUnknownKeys = allowUnknownKeys;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setSftpVersionSelector(SftpVersionSelector sftpVersionSelector) {
        Assert.notNull((Object)sftpVersionSelector, (String)"'sftpVersionSelector' must noy be null");
        this.sftpVersionSelector = sftpVersionSelector;
    }

    public void setSshClientConfigurer(Consumer<SshClient> sshClientConfigurer) {
        Assert.state((boolean)this.isInnerClient, (String)"Cannot mutate externally provided SshClient");
        Assert.notNull(sshClientConfigurer, (String)"'sshClientConfigurer' must noy be null");
        this.sshClientConfigurer = sshClientConfigurer;
    }

    public SftpSession getSession() {
        SftpSession sftpSession;
        if (this.sharedSessionLock != null) {
            this.sharedSessionLock.lock();
        }
        SftpClient sftpClient = this.sharedSftpClient;
        try {
            boolean freshSftpClient = false;
            if (sftpClient == null || !sftpClient.isOpen()) {
                sftpClient = this.createSftpClient(this.initClientSession(), this.sftpVersionSelector, SftpErrorDataHandler.EMPTY);
                freshSftpClient = true;
            }
            sftpSession = new SftpSession(sftpClient, this.isSharedSession);
            sftpSession.connect();
            if (this.isSharedSession && freshSftpClient) {
                this.sharedSftpClient = sftpClient;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("failed to create SFTP Session", ex);
        }
        finally {
            if (this.sharedSessionLock != null) {
                this.sharedSessionLock.unlock();
            }
        }
        return sftpSession;
    }

    private ClientSession initClientSession() throws IOException {
        Assert.hasText((String)this.host, (String)"host must not be empty");
        Assert.hasText((String)this.user, (String)"user must not be empty");
        this.initClient();
        Duration verifyTimeout = this.timeout != null ? Duration.ofMillis(this.timeout.intValue()) : null;
        HostConfigEntry config = this.hostConfig;
        if (config == null) {
            config = new HostConfigEntry(SshdSocketAddress.isIPv6Address((String)this.host) ? "" : this.host, this.host, this.port, this.user);
        }
        ClientSession clientSession = (ClientSession)((ConnectFuture)this.sshClient.connect(config).verify(verifyTimeout)).getSession();
        clientSession.auth().verify(verifyTimeout);
        return clientSession;
    }

    private void initClient() throws IOException {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (!this.initialized) {
                    this.doInitClient();
                    this.initialized = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void doInitClient() throws IOException {
        if (this.port <= 0) {
            this.port = 22;
        }
        this.doInitInnerClient();
        this.sshClient.start();
    }

    private void doInitInnerClient() throws IOException {
        if (this.isInnerClient) {
            Object serverKeyVerifier;
            Object object = serverKeyVerifier = this.allowUnknownKeys ? AcceptAllServerKeyVerifier.INSTANCE : RejectAllServerKeyVerifier.INSTANCE;
            if (this.knownHosts != null) {
                serverKeyVerifier = new ResourceKnownHostsServerKeyVerifier(this.knownHosts);
            }
            this.sshClient.setServerKeyVerifier((ServerKeyVerifier)serverKeyVerifier);
            this.sshClient.setPasswordIdentityProvider(PasswordIdentityProvider.wrapPasswords((String[])new String[]{this.password}));
            if (this.privateKey != null) {
                AbstractIoResource<Resource> privateKeyResource = new AbstractIoResource<Resource>(Resource.class, this.privateKey){

                    public InputStream openInputStream() throws IOException {
                        return ((Resource)this.getResourceValue()).getInputStream();
                    }
                };
                try {
                    Collection keys = SecurityUtils.getKeyPairResourceParser().loadKeyPairs(null, (IoResource)privateKeyResource, FilePasswordProvider.of((String)this.privateKeyPassphrase));
                    this.sshClient.setKeyIdentityProvider(KeyIdentityProvider.wrapKeyPairs((Iterable)keys));
                }
                catch (GeneralSecurityException ex) {
                    throw new IOException("Cannot load private key: " + this.privateKey.getFilename(), ex);
                }
            }
            this.sshClient.setUserInteraction(this.userInteraction);
            this.sshClientConfigurer.accept(this.sshClient);
        }
    }

    public final boolean isSharedSession() {
        return this.isSharedSession;
    }

    public void resetSharedSession() {
        Assert.state((boolean)this.isSharedSession, (String)"Shared sessions are not being used");
        this.sharedSftpClient = null;
    }

    protected SftpClient createSftpClient(ClientSession clientSession, SftpVersionSelector initialVersionSelector, SftpErrorDataHandler errorDataHandler) throws IOException {
        return new ConcurrentSftpClient(clientSession, initialVersionSelector, errorDataHandler);
    }

    public void destroy() {
        SftpClient sharedSftpClientToClose;
        if (this.isInnerClient && this.sshClient != null && this.sshClient.isStarted()) {
            this.sshClient.stop();
        }
        if ((sharedSftpClientToClose = this.sharedSftpClient) != null) {
            try {
                sharedSftpClientToClose.close();
            }
            catch (IOException ex) {
                throw new UncheckedIOException("failed to close an SFTP client", ex);
            }
            try {
                ClientSession session = sharedSftpClientToClose.getSession();
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException("failed to close an SFTP client (session)", ex);
            }
        }
    }

    protected class ConcurrentSftpClient
    extends DefaultSftpClient {
        private final Lock sftpWriteLock;

        protected ConcurrentSftpClient(ClientSession clientSession, SftpVersionSelector initialVersionSelector, SftpErrorDataHandler errorDataHandler) throws IOException {
            super(clientSession, initialVersionSelector, errorDataHandler);
            this.sftpWriteLock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SftpMessage write(int cmd, Buffer buffer) throws IOException {
            this.sftpWriteLock.lock();
            try {
                SftpMessage sftpMessage = super.write(cmd, buffer);
                sftpMessage.waitUntilSent();
                SftpMessage sftpMessage2 = sftpMessage;
                return sftpMessage2;
            }
            finally {
                this.sftpWriteLock.unlock();
            }
        }

        protected ChannelSubsystem createSftpChannelSubsystem(ClientSession clientSession) {
            ChannelSubsystem sftpChannelSubsystem = super.createSftpChannelSubsystem(clientSession);
            PropertyResolverUtils.updateProperty((PropertyResolver)sftpChannelSubsystem, (String)AbstractSftpClient.SFTP_CLIENT_CMD_TIMEOUT.getName(), (Object)DefaultSftpSessionFactory.this.timeout);
            return sftpChannelSubsystem;
        }
    }
}

