/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.common.SftpException;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class SftpSession
implements Session<SftpClient.DirEntry> {
    private final SftpClient sftpClient;

    public SftpSession(SftpClient sftpClient) {
        Assert.notNull((Object)sftpClient, (String)"'sftpClient' must not be null");
        this.sftpClient = sftpClient;
    }

    public boolean remove(String path) throws IOException {
        try {
            this.sftpClient.remove(path);
        }
        catch (SftpException sftpEx) {
            if (2 == sftpEx.getStatus()) {
                return false;
            }
            throw sftpEx;
        }
        return true;
    }

    public SftpClient.DirEntry[] list(String path) throws IOException {
        return (SftpClient.DirEntry[])this.doList(path).toArray(SftpClient.DirEntry[]::new);
    }

    public String[] listNames(String path) throws IOException {
        return (String[])this.doList(path).map(SftpClient.DirEntry::getFilename).toArray(String[]::new);
    }

    public Stream<SftpClient.DirEntry> doList(String path) throws IOException {
        boolean isPattern;
        String remotePath;
        String remoteDir = remotePath = StringUtils.trimTrailingCharacter((String)path, (char)'/');
        int lastIndex = remotePath.lastIndexOf(47);
        if (lastIndex > 0) {
            remoteDir = remoteDir.substring(0, lastIndex);
        }
        String remoteFile = lastIndex > 0 ? remotePath.substring(lastIndex + 1) : null;
        boolean bl = isPattern = remoteFile != null && remoteFile.contains("*");
        if (!isPattern && remoteFile != null) {
            SftpClient.Attributes attributes = this.sftpClient.lstat(path);
            if (!attributes.isDirectory()) {
                return Stream.of(new SftpClient.DirEntry(remoteFile, path, attributes));
            }
            remoteDir = remotePath;
        }
        remoteDir = this.normalizePath(remoteDir);
        return StreamSupport.stream(this.sftpClient.readDir(remoteDir).spliterator(), false).filter(entry -> !isPattern || PatternMatchUtils.simpleMatch((String)remoteFile, (String)entry.getFilename()));
    }

    public void read(String source, OutputStream os) throws IOException {
        InputStream is = this.readRaw(source);
        FileCopyUtils.copy((InputStream)is, (OutputStream)os);
    }

    public InputStream readRaw(String source) throws IOException {
        return this.sftpClient.read(this.normalizePath(source));
    }

    private String normalizePath(String path) throws IOException {
        return !path.isEmpty() && path.charAt(0) == '/' ? path : this.sftpClient.canonicalPath(path);
    }

    public boolean finalizeRaw() {
        return true;
    }

    public void write(InputStream inputStream, String destination) throws IOException {
        OutputStream outputStream = this.sftpClient.write(destination);
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public void append(InputStream inputStream, String destination) throws IOException {
        OutputStream outputStream = this.sftpClient.write(destination, new SftpClient.OpenMode[]{SftpClient.OpenMode.Create, SftpClient.OpenMode.Write, SftpClient.OpenMode.Append});
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public void close() {
        try {
            this.sftpClient.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to close an SFTP client", ex);
        }
        try {
            ClientSession session = this.sftpClient.getSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to close an SFTP client (session)", ex);
        }
    }

    public boolean isOpen() {
        return this.sftpClient.isOpen();
    }

    public void rename(String pathFrom, String pathTo) throws IOException {
        if (this.sftpClient.getVersion() >= 5) {
            this.sftpClient.rename(pathFrom, pathTo, new SftpClient.CopyMode[]{SftpClient.CopyMode.Overwrite});
        } else {
            this.remove(pathTo);
            this.sftpClient.rename(pathFrom, pathTo);
        }
    }

    public boolean mkdir(String remoteDirectory) throws IOException {
        this.sftpClient.mkdir(remoteDirectory);
        return true;
    }

    public boolean rmdir(String remoteDirectory) throws IOException {
        this.sftpClient.rmdir(remoteDirectory);
        return true;
    }

    public boolean exists(String path) {
        try {
            this.sftpClient.lstat(this.normalizePath(path));
            return true;
        }
        catch (SftpException ex) {
            if (2 == ex.getStatus()) {
                return false;
            }
            throw new UncheckedIOException("Cannot check 'lstat' for path " + path, (IOException)((Object)ex));
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Cannot check 'lstat' for path " + path, ex);
        }
    }

    void connect() {
        try {
            if (!this.sftpClient.isOpen()) {
                Duration initializationTimeout = (Duration)SftpModuleProperties.SFTP_CHANNEL_OPEN_TIMEOUT.getRequired((PropertyResolver)this.sftpClient.getSession());
                this.sftpClient.getClientChannel().open().verify(initializationTimeout);
            }
        }
        catch (IOException ex) {
            this.close();
            throw new UncheckedIOException("failed to connect an SFTP client", ex);
        }
    }

    public SftpClient getClientInstance() {
        return this.sftpClient;
    }

    public String getHostPort() {
        SocketAddress connectAddress = this.sftpClient.getSession().getConnectAddress();
        return SshdSocketAddress.toAddressString((SocketAddress)connectAddress) + ":" + SshdSocketAddress.toAddressPort((SocketAddress)connectAddress);
    }

    public boolean test() {
        return this.isOpen() && this.doTest();
    }

    private boolean doTest() {
        try {
            this.sftpClient.canonicalPath("");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

