/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.gateway;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.ClientCallbackWithoutResult;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.sftp.session.SftpFileInfo;
import org.springframework.integration.sftp.session.SftpRemoteFileTemplate;
import org.springframework.integration.sftp.support.GeneralSftpException;
import org.springframework.util.ReflectionUtils;

public class SftpOutboundGateway
extends AbstractRemoteFileOutboundGateway<ChannelSftp.LsEntry> {
    private static final Method LS_ENTRY_SET_FILENAME_METHOD = ReflectionUtils.findMethod(ChannelSftp.LsEntry.class, (String)"setFilename", (Class[])new Class[]{String.class});

    public SftpOutboundGateway(SessionFactory<ChannelSftp.LsEntry> sessionFactory, MessageSessionCallback<ChannelSftp.LsEntry, ?> messageSessionCallback) {
        this(new SftpRemoteFileTemplate(sessionFactory), messageSessionCallback);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public SftpOutboundGateway(RemoteFileTemplate<ChannelSftp.LsEntry> remoteFileTemplate, MessageSessionCallback<ChannelSftp.LsEntry, ?> messageSessionCallback) {
        super(remoteFileTemplate, messageSessionCallback);
    }

    public SftpOutboundGateway(SessionFactory<ChannelSftp.LsEntry> sessionFactory, String command, String expression) {
        this(new SftpRemoteFileTemplate(sessionFactory), command, expression);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public SftpOutboundGateway(RemoteFileTemplate<ChannelSftp.LsEntry> remoteFileTemplate, String command, String expression) {
        super(remoteFileTemplate, command, expression);
    }

    protected boolean isDirectory(ChannelSftp.LsEntry file) {
        return file.getAttrs().isDir();
    }

    protected boolean isLink(ChannelSftp.LsEntry file) {
        return file.getAttrs().isLink();
    }

    protected String getFilename(ChannelSftp.LsEntry file) {
        return file.getFilename();
    }

    protected String getFilename(AbstractFileInfo<ChannelSftp.LsEntry> file) {
        return file.getFilename();
    }

    protected List<AbstractFileInfo<ChannelSftp.LsEntry>> asFileInfoList(Collection<ChannelSftp.LsEntry> files) {
        return files.stream().map(SftpFileInfo::new).collect(Collectors.toList());
    }

    protected long getModified(ChannelSftp.LsEntry file) {
        return (long)file.getAttrs().getMTime() * 1000L;
    }

    protected ChannelSftp.LsEntry enhanceNameWithSubDirectory(ChannelSftp.LsEntry file, String directory) {
        ReflectionUtils.invokeMethod((Method)LS_ENTRY_SET_FILENAME_METHOD, (Object)file, (Object[])new Object[]{directory + file.getFilename()});
        return file;
    }

    public String getComponentType() {
        return "sftp:outbound-gateway";
    }

    public boolean isChmodCapable() {
        return true;
    }

    protected void doChmod(RemoteFileOperations<ChannelSftp.LsEntry> remoteFileOperations, String path, int chmod) {
        remoteFileOperations.executeWithClient((ClientCallback)((ClientCallbackWithoutResult)client -> {
            try {
                client.chmod(chmod, path);
            }
            catch (SftpException e) {
                throw new GeneralSftpException("Failed to execute 'chmod " + Integer.toOctalString(chmod) + " " + path + "'", e);
            }
        }));
    }

    static {
        if (LS_ENTRY_SET_FILENAME_METHOD != null) {
            ReflectionUtils.makeAccessible((Method)LS_ENTRY_SET_FILENAME_METHOD);
        }
    }
}

