/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.integration.sftp.session.JSchSessionWrapper;
import org.springframework.integration.sftp.session.JschLogger;
import org.springframework.integration.sftp.session.SftpSession;
import org.springframework.integration.util.JavaUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class DefaultSftpSessionFactory
implements SessionFactory<ChannelSftp.LsEntry>,
SharedSessionCapable {
    private static final Log logger = LogFactory.getLog(DefaultSftpSessionFactory.class);
    private final UserInfo userInfoWrapper = new UserInfoWrapper();
    private final JSch jsch;
    private final boolean isSharedSession;
    private final Lock sharedSessionLock;
    private String host;
    private int port = 22;
    private String user;
    private String password;
    private String knownHosts;
    private Resource privateKey;
    private String privateKeyPassphrase;
    private Properties sessionConfig;
    private Proxy proxy;
    private SocketFactory socketFactory;
    private Integer timeout;
    private String clientVersion;
    private String hostKeyAlias;
    private Integer serverAliveInterval;
    private Integer serverAliveCountMax;
    private Boolean enableDaemonThread;
    private UserInfo userInfo;
    private boolean allowUnknownKeys = false;
    private Duration channelConnectTimeout;
    private volatile JSchSessionWrapper sharedJschSession;

    public DefaultSftpSessionFactory() {
        this(false);
    }

    public DefaultSftpSessionFactory(boolean isSharedSession) {
        this(new JSch(), isSharedSession);
    }

    public DefaultSftpSessionFactory(JSch jsch, boolean isSharedSession) {
        this.jsch = jsch;
        this.isSharedSession = isSharedSession;
        this.sharedSessionLock = this.isSharedSession ? new ReentrantLock() : null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public void setPrivateKey(Resource privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public void setSessionConfig(Properties sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void setHostKeyAlias(String hostKeyAlias) {
        this.hostKeyAlias = hostKeyAlias;
    }

    public void setServerAliveInterval(Integer serverAliveInterval) {
        this.serverAliveInterval = serverAliveInterval;
    }

    public void setServerAliveCountMax(Integer serverAliveCountMax) {
        this.serverAliveCountMax = serverAliveCountMax;
    }

    public void setEnableDaemonThread(Boolean enableDaemonThread) {
        this.enableDaemonThread = enableDaemonThread;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setAllowUnknownKeys(boolean allowUnknownKeys) {
        this.allowUnknownKeys = allowUnknownKeys;
    }

    public void setChannelConnectTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"'connectTimeout' cannot be null");
        this.channelConnectTimeout = timeout;
    }

    public SftpSession getSession() {
        SftpSession sftpSession;
        JSchSessionWrapper jschSession = this.sharedJschSession;
        if (this.sharedSessionLock != null) {
            this.sharedSessionLock.lock();
        }
        try {
            boolean freshJschSession = false;
            if (jschSession == null || !jschSession.isConnected()) {
                jschSession = new JSchSessionWrapper(this.initJschSession());
                freshJschSession = true;
            }
            sftpSession = new SftpSession(jschSession);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.channelConnectTimeout, sftpSession::setChannelConnectTimeout);
            sftpSession.connect();
            if (this.isSharedSession && freshJschSession) {
                this.sharedJschSession = jschSession;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create SFTP Session", e);
        }
        finally {
            if (this.sharedSessionLock != null) {
                this.sharedSessionLock.unlock();
            }
        }
        jschSession.addChannel();
        return sftpSession;
    }

    private Session initJschSession() throws JSchException, IOException {
        Assert.hasText((String)this.host, (String)"host must not be empty");
        Assert.hasText((String)this.user, (String)"user must not be empty");
        Assert.isTrue((StringUtils.hasText((String)this.userInfoWrapper.getPassword()) || this.privateKey != null ? 1 : 0) != 0, (String)"either a password or a private key is required");
        if (this.port <= 0) {
            this.port = 22;
        }
        if (StringUtils.hasText((String)this.knownHosts)) {
            this.jsch.setKnownHosts(this.knownHosts);
        }
        if (this.privateKey != null) {
            byte[] keyByteArray = FileCopyUtils.copyToByteArray((InputStream)this.privateKey.getInputStream());
            String passphrase = this.userInfoWrapper.getPassphrase();
            if (StringUtils.hasText((String)passphrase)) {
                this.jsch.addIdentity(this.user, keyByteArray, null, passphrase.getBytes());
            } else {
                this.jsch.addIdentity(this.user, keyByteArray, null, null);
            }
        }
        Session jschSession = this.jsch.getSession(this.user, this.host, this.port);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.sessionConfig, arg_0 -> ((Session)jschSession).setConfig(arg_0)).acceptIfHasText(this.userInfoWrapper.getPassword(), arg_0 -> ((Session)jschSession).setPassword(arg_0));
        jschSession.setUserInfo(this.userInfoWrapper);
        try {
            if (this.timeout != null) {
                jschSession.setTimeout(this.timeout.intValue());
            }
            if (this.serverAliveInterval != null) {
                jschSession.setServerAliveInterval(this.serverAliveInterval.intValue());
            }
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.proxy, arg_0 -> ((Session)jschSession).setProxy(arg_0)).acceptIfNotNull((Object)this.socketFactory, arg_0 -> ((Session)jschSession).setSocketFactory(arg_0)).acceptIfHasText(this.clientVersion, arg_0 -> ((Session)jschSession).setClientVersion(arg_0)).acceptIfHasText(this.hostKeyAlias, arg_0 -> ((Session)jschSession).setHostKeyAlias(arg_0)).acceptIfNotNull((Object)this.serverAliveCountMax, arg_0 -> ((Session)jschSession).setServerAliveCountMax(arg_0)).acceptIfNotNull((Object)this.enableDaemonThread, arg_0 -> ((Session)jschSession).setDaemonThread(arg_0));
        }
        catch (Exception e) {
            throw new BeanCreationException("Attempt to set additional properties of the com.jcraft.jsch.Session resulted in error: " + e.getMessage(), (Throwable)e);
        }
        return jschSession;
    }

    public final boolean isSharedSession() {
        return this.isSharedSession;
    }

    public void resetSharedSession() {
        Assert.state((boolean)this.isSharedSession, (String)"Shared sessions are not being used");
        this.sharedJschSession = null;
    }

    static {
        JSch.setLogger((Logger)new JschLogger());
    }

    private class UserInfoWrapper
    implements UserInfo,
    UIKeyboardInteractive {
        UserInfoWrapper() {
        }

        private boolean hasDelegate() {
            return this.getDelegate() != null;
        }

        private UserInfo getDelegate() {
            return DefaultSftpSessionFactory.this.userInfo;
        }

        public String getPassphrase() {
            if (this.hasDelegate()) {
                Assert.state((!StringUtils.hasText((String)DefaultSftpSessionFactory.this.privateKeyPassphrase) ? 1 : 0) != 0, (String)"When a 'UserInfo' is provided, 'privateKeyPassphrase' is not allowed");
                return this.getDelegate().getPassphrase();
            }
            return DefaultSftpSessionFactory.this.privateKeyPassphrase;
        }

        public String getPassword() {
            if (this.hasDelegate()) {
                Assert.state((!StringUtils.hasText((String)DefaultSftpSessionFactory.this.password) ? 1 : 0) != 0, (String)"When a 'UserInfo' is provided, 'password' is not allowed");
                return this.getDelegate().getPassword();
            }
            return DefaultSftpSessionFactory.this.password;
        }

        public boolean promptPassword(String message) {
            if (this.hasDelegate()) {
                return this.getDelegate().promptPassword(message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UserInfo provided - " + message + ", returning: true"));
            }
            return true;
        }

        public boolean promptPassphrase(String message) {
            if (this.hasDelegate()) {
                return this.getDelegate().promptPassphrase(message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UserInfo provided - " + message + ", returning: true"));
            }
            return true;
        }

        public boolean promptYesNo(String message) {
            logger.info((Object)message);
            if (this.hasDelegate()) {
                return this.getDelegate().promptYesNo(message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UserInfo provided - " + message + ", returning:" + DefaultSftpSessionFactory.this.allowUnknownKeys));
            }
            return DefaultSftpSessionFactory.this.allowUnknownKeys;
        }

        public void showMessage(String message) {
            if (this.hasDelegate()) {
                this.getDelegate().showMessage(message);
            } else {
                logger.debug((Object)message);
            }
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (this.hasDelegate() && this.getDelegate() instanceof UIKeyboardInteractive) {
                return ((UIKeyboardInteractive)this.getDelegate()).promptKeyboardInteractive(destination, name, instruction, prompt, echo);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UIKeyboardInteractive provided - " + destination + ":" + name + ":" + instruction + ":" + Arrays.asList(prompt) + ":" + Arrays.toString(echo)));
            }
            return null;
        }
    }
}

