/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.integration.sftp.session.JSchSessionWrapper;
import org.springframework.integration.sftp.session.JschLogger;
import org.springframework.integration.sftp.session.SftpSession;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class DefaultSftpSessionFactory
implements SessionFactory<ChannelSftp.LsEntry>,
SharedSessionCapable {
    private static final Log logger = LogFactory.getLog(DefaultSftpSessionFactory.class);
    private final ReadWriteLock sharedSessionLock = new ReentrantReadWriteLock();
    private final UserInfo userInfoWrapper = new UserInfoWrapper();
    private final JSch jsch;
    private final boolean isSharedSession;
    private volatile String host;
    private volatile int port = 22;
    private volatile String user;
    private volatile String password;
    private volatile String knownHosts;
    private volatile Resource privateKey;
    private volatile String privateKeyPassphrase;
    private volatile Properties sessionConfig;
    private volatile Proxy proxy;
    private volatile SocketFactory socketFactory;
    private volatile Integer timeout;
    private volatile String clientVersion;
    private volatile String hostKeyAlias;
    private volatile Integer serverAliveInterval;
    private volatile Integer serverAliveCountMax;
    private volatile Boolean enableDaemonThread;
    private volatile JSchSessionWrapper sharedJschSession;
    private volatile UserInfo userInfo;
    private volatile boolean allowUnknownKeys = false;

    public DefaultSftpSessionFactory() {
        this(false);
    }

    public DefaultSftpSessionFactory(boolean isSharedSession) {
        this(new JSch(), isSharedSession);
    }

    public DefaultSftpSessionFactory(JSch jsch, boolean isSharedSession) {
        this.jsch = jsch;
        this.isSharedSession = isSharedSession;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public void setPrivateKey(Resource privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public void setSessionConfig(Properties sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void setHostKeyAlias(String hostKeyAlias) {
        this.hostKeyAlias = hostKeyAlias;
    }

    public void setServerAliveInterval(Integer serverAliveInterval) {
        this.serverAliveInterval = serverAliveInterval;
    }

    public void setServerAliveCountMax(Integer serverAliveCountMax) {
        this.serverAliveCountMax = serverAliveCountMax;
    }

    public void setEnableDaemonThread(Boolean enableDaemonThread) {
        this.enableDaemonThread = enableDaemonThread;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setAllowUnknownKeys(boolean allowUnknownKeys) {
        this.allowUnknownKeys = allowUnknownKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpSession getSession() {
        Assert.hasText((String)this.host, (String)"host must not be empty");
        Assert.hasText((String)this.user, (String)"user must not be empty");
        Assert.isTrue((StringUtils.hasText((String)this.userInfoWrapper.getPassword()) || this.privateKey != null ? 1 : 0) != 0, (String)"either a password or a private key is required");
        try {
            JSchSessionWrapper jschSession;
            if (this.isSharedSession) {
                block12: {
                    this.sharedSessionLock.readLock().lock();
                    try {
                        if (this.sharedJschSession != null && this.sharedJschSession.isConnected()) break block12;
                        this.sharedSessionLock.readLock().unlock();
                        this.sharedSessionLock.writeLock().lock();
                        try {
                            if (this.sharedJschSession != null && this.sharedJschSession.isConnected()) break block12;
                            this.sharedJschSession = new JSchSessionWrapper(this.initJschSession());
                            try {
                                this.sharedJschSession.getSession().connect();
                            }
                            catch (JSchException e) {
                                throw new IllegalStateException("failed to connect", e);
                            }
                        }
                        finally {
                            this.sharedSessionLock.readLock().lock();
                            this.sharedSessionLock.writeLock().unlock();
                        }
                    }
                    finally {
                        this.sharedSessionLock.readLock().unlock();
                    }
                }
                jschSession = this.sharedJschSession;
            } else {
                jschSession = new JSchSessionWrapper(this.initJschSession());
            }
            SftpSession sftpSession = new SftpSession(jschSession);
            sftpSession.connect();
            jschSession.addChannel();
            return sftpSession;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create SFTP Session", e);
        }
    }

    private Session initJschSession() throws Exception {
        String pw;
        if (this.port <= 0) {
            this.port = 22;
        }
        if (StringUtils.hasText((String)this.knownHosts)) {
            this.jsch.setKnownHosts(this.knownHosts);
        }
        if (this.privateKey != null) {
            byte[] keyByteArray = FileCopyUtils.copyToByteArray((InputStream)this.privateKey.getInputStream());
            String passphrase = this.userInfoWrapper.getPassphrase();
            if (StringUtils.hasText((String)passphrase)) {
                this.jsch.addIdentity(this.user, keyByteArray, null, passphrase.getBytes());
            } else {
                this.jsch.addIdentity(this.user, keyByteArray, null, null);
            }
        }
        Session jschSession = this.jsch.getSession(this.user, this.host, this.port);
        if (this.sessionConfig != null) {
            jschSession.setConfig(this.sessionConfig);
        }
        if (StringUtils.hasText((String)(pw = this.userInfoWrapper.getPassword()))) {
            jschSession.setPassword(pw);
        }
        jschSession.setUserInfo(this.userInfoWrapper);
        try {
            if (this.proxy != null) {
                jschSession.setProxy(this.proxy);
            }
            if (this.socketFactory != null) {
                jschSession.setSocketFactory(this.socketFactory);
            }
            if (this.timeout != null) {
                jschSession.setTimeout(this.timeout.intValue());
            }
            if (StringUtils.hasText((String)this.clientVersion)) {
                jschSession.setClientVersion(this.clientVersion);
            }
            if (StringUtils.hasText((String)this.hostKeyAlias)) {
                jschSession.setHostKeyAlias(this.hostKeyAlias);
            }
            if (this.serverAliveInterval != null) {
                jschSession.setServerAliveInterval(this.serverAliveInterval.intValue());
            }
            if (this.serverAliveCountMax != null) {
                jschSession.setServerAliveCountMax(this.serverAliveCountMax.intValue());
            }
            if (this.enableDaemonThread != null) {
                jschSession.setDaemonThread(this.enableDaemonThread.booleanValue());
            }
        }
        catch (Exception e) {
            throw new BeanCreationException("Attempt to set additional properties of the com.jcraft.jsch.Session resulted in error: " + e.getMessage(), (Throwable)e);
        }
        return jschSession;
    }

    public final boolean isSharedSession() {
        return this.isSharedSession;
    }

    public void resetSharedSession() {
        Assert.state((boolean)this.isSharedSession, (String)"Shared sessions are not being used");
        this.sharedJschSession = null;
    }

    static {
        JSch.setLogger((Logger)new JschLogger());
    }

    private class UserInfoWrapper
    implements UserInfo,
    UIKeyboardInteractive {
        UserInfoWrapper() {
        }

        private boolean hasDelegate() {
            return this.getDelegate() != null;
        }

        private UserInfo getDelegate() {
            return DefaultSftpSessionFactory.this.userInfo;
        }

        public String getPassphrase() {
            if (this.hasDelegate()) {
                Assert.state((!StringUtils.hasText((String)DefaultSftpSessionFactory.this.privateKeyPassphrase) ? 1 : 0) != 0, (String)"When a 'UserInfo' is provided, 'privateKeyPassphrase' is not allowed");
                return this.getDelegate().getPassphrase();
            }
            return DefaultSftpSessionFactory.this.privateKeyPassphrase;
        }

        public String getPassword() {
            if (this.hasDelegate()) {
                Assert.state((!StringUtils.hasText((String)DefaultSftpSessionFactory.this.password) ? 1 : 0) != 0, (String)"When a 'UserInfo' is provided, 'password' is not allowed");
                return this.getDelegate().getPassword();
            }
            return DefaultSftpSessionFactory.this.password;
        }

        public boolean promptPassword(String message) {
            if (this.hasDelegate()) {
                return this.getDelegate().promptPassword(message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UserInfo provided - " + message + ", returning: true"));
            }
            return true;
        }

        public boolean promptPassphrase(String message) {
            if (this.hasDelegate()) {
                return this.getDelegate().promptPassphrase(message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UserInfo provided - " + message + ", returning: true"));
            }
            return true;
        }

        public boolean promptYesNo(String message) {
            logger.info((Object)message);
            if (this.hasDelegate()) {
                return this.getDelegate().promptYesNo(message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UserInfo provided - " + message + ", returning:" + DefaultSftpSessionFactory.this.allowUnknownKeys));
            }
            return DefaultSftpSessionFactory.this.allowUnknownKeys;
        }

        public void showMessage(String message) {
            if (this.hasDelegate()) {
                this.getDelegate().showMessage(message);
            } else {
                logger.debug((Object)message);
            }
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (this.hasDelegate() && this.getDelegate() instanceof UIKeyboardInteractive) {
                return ((UIKeyboardInteractive)this.getDelegate()).promptKeyboardInteractive(destination, name, instruction, prompt, echo);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No UIKeyboardInteractive provided - " + destination + ":" + name + ":" + instruction + ":" + Arrays.asList(prompt) + ":" + Arrays.asList(new boolean[][]{echo})));
            }
            return null;
        }
    }
}

