/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.security.channel.ChannelSecurityInterceptor;
import org.springframework.integration.security.config.ChannelSecurityInterceptorBeanPostProcessor;
import org.springframework.integration.security.config.ChannelSecurityInterceptorFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SecurityIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final String CHANNEL_SECURITY_INTERCEPTOR_BPP_BEAN_NAME = ChannelSecurityInterceptorBeanPostProcessor.class.getName();

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        ManagedList securityInterceptors = new ManagedList();
        for (String beanName : registry.getBeanDefinitionNames()) {
            MethodMetadata beanMethod;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            String beanClassName = beanDefinition.getBeanClassName();
            Class<?> clazz = null;
            if (StringUtils.hasText((String)beanClassName)) {
                try {
                    clazz = ClassUtils.forName((String)beanClassName, (ClassLoader)beanFactory.getBeanClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new CannotLoadBeanClassException(this.toString(), beanName, beanClassName, e);
                }
            } else if (beanDefinition instanceof AnnotatedBeanDefinition && beanDefinition.getSource() instanceof MethodMetadata && (beanMethod = (MethodMetadata)beanDefinition.getSource()) instanceof StandardMethodMetadata) {
                Method method = ((StandardMethodMetadata)beanMethod).getIntrospectedMethod();
                clazz = method.getReturnType();
            }
            if (clazz == null || !ChannelSecurityInterceptor.class.isAssignableFrom(clazz) && !ChannelSecurityInterceptorFactoryBean.class.isAssignableFrom(clazz)) continue;
            securityInterceptors.add(beanDefinition);
        }
        if (!securityInterceptors.isEmpty()) {
            AbstractBeanDefinition securityPostProcessorBd = BeanDefinitionBuilder.rootBeanDefinition(ChannelSecurityInterceptorBeanPostProcessor.class).addConstructorArgValue((Object)securityInterceptors).getBeanDefinition();
            registry.registerBeanDefinition(CHANNEL_SECURITY_INTERCEPTOR_BPP_BEAN_NAME, (BeanDefinition)securityPostProcessorBd);
        }
    }
}

