/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.integration.security.channel.ChannelSecurityInterceptor;
import org.springframework.integration.security.channel.ChannelSecurityMetadataSource;
import org.springframework.messaging.MessageChannel;

public class ChannelSecurityInterceptorBeanPostProcessor
implements BeanPostProcessor {
    private final Collection<ChannelSecurityInterceptor> securityInterceptors;

    public ChannelSecurityInterceptorBeanPostProcessor(Collection<ChannelSecurityInterceptor> securityInterceptors) {
        this.securityInterceptors = securityInterceptors;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MessageChannel) {
            for (ChannelSecurityInterceptor securityInterceptor : this.securityInterceptors) {
                ChannelSecurityMetadataSource channelSecurityMetadataSource = (ChannelSecurityMetadataSource)securityInterceptor.obtainSecurityMetadataSource();
                if (!this.shouldProxy(beanName, channelSecurityMetadataSource)) continue;
                if (AopUtils.isAopProxy((Object)bean) && bean instanceof Advised) {
                    ((Advised)bean).addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)securityInterceptor));
                    continue;
                }
                ProxyFactory proxyFactory = new ProxyFactory(bean);
                proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)securityInterceptor));
                bean = proxyFactory.getProxy();
            }
        }
        return bean;
    }

    private boolean shouldProxy(String beanName, ChannelSecurityMetadataSource channelSecurityMetadataSource) {
        Set<Pattern> patterns = channelSecurityMetadataSource.getPatterns();
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(beanName).matches()) continue;
            return true;
        }
        return false;
    }
}

