/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.channel;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.integration.security.channel.ChannelInvocation;
import org.springframework.integration.security.channel.ChannelSecurityMetadataSource;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.util.Assert;

public final class ChannelSecurityInterceptor
extends AbstractSecurityInterceptor
implements MethodInterceptor {
    private final ChannelSecurityMetadataSource securityMetadataSource;

    public ChannelSecurityInterceptor(ChannelSecurityMetadataSource securityMetadataSource) {
        Assert.notNull((Object)securityMetadataSource, (String)"securityMetadataSource must not be null");
        this.securityMetadataSource = securityMetadataSource;
    }

    public Class<?> getSecureObjectClass() {
        return ChannelInvocation.class;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method.getName().equals("send") || method.getName().equals("receive")) {
            return this.invokeWithAuthorizationCheck(invocation);
        }
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeWithAuthorizationCheck(MethodInvocation methodInvocation) throws Throwable {
        Object returnValue = null;
        InterceptorStatusToken token = super.beforeInvocation((Object)new ChannelInvocation(methodInvocation));
        try {
            returnValue = methodInvocation.proceed();
        }
        finally {
            returnValue = super.afterInvocation(token, returnValue);
        }
        return returnValue;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }
}

