/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.dsl;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.RefreshableResourceScriptSource;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.integration.scripting.config.ScriptExecutingProcessorFactory;
import org.springframework.integration.scripting.jsr223.ScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.jsr223.ScriptExecutorFactory;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DslScriptExecutingMessageProcessor
implements MessageProcessor<Object>,
InitializingBean,
ApplicationContextAware,
BeanClassLoaderAware {
    private Resource script;
    private @Nullable String location;
    private @Nullable String lang;
    private long refreshCheckDelay = -1L;
    private ScriptVariableGenerator variableGenerator;
    private ApplicationContext applicationContext;
    private AbstractScriptExecutingMessageProcessor<?> delegate;
    private ClassLoader classLoader;

    DslScriptExecutingMessageProcessor(Resource script) {
        this.script = script;
    }

    DslScriptExecutingMessageProcessor(String location) {
        this.location = location;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setRefreshCheckDelay(Long refreshCheckDelay) {
        this.refreshCheckDelay = refreshCheckDelay;
    }

    public void setVariableGenerator(ScriptVariableGenerator variableGenerator) {
        this.variableGenerator = variableGenerator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() {
        if (StringUtils.hasText((String)this.location)) {
            this.script = this.applicationContext.getResource(this.location);
        }
        if (!StringUtils.hasText((String)this.lang)) {
            String scriptFilename = this.script.getFilename();
            Assert.hasText((String)scriptFilename, () -> "Either 'lang' or file extension must be provided for script: " + String.valueOf(this.script));
            this.lang = ScriptExecutorFactory.deriveLanguageFromFileExtension(scriptFilename);
        }
        RefreshableResourceScriptSource scriptSource = new RefreshableResourceScriptSource(this.script, this.refreshCheckDelay);
        if (this.applicationContext.containsBean("integrationScriptExecutingProcessorFactory")) {
            ScriptExecutingProcessorFactory processorFactory = (ScriptExecutingProcessorFactory)this.applicationContext.getBean("integrationScriptExecutingProcessorFactory", ScriptExecutingProcessorFactory.class);
            this.delegate = processorFactory.createMessageProcessor(this.lang, scriptSource, this.variableGenerator);
        } else {
            this.delegate = new ScriptExecutingMessageProcessor((ScriptSource)scriptSource, this.variableGenerator, ScriptExecutorFactory.getScriptExecutor(this.lang));
        }
        this.delegate.setBeanFactory((BeanFactory)this.applicationContext);
        this.delegate.setBeanClassLoader(this.classLoader);
    }

    public @Nullable Object processMessage(Message<?> message) {
        return this.delegate.processMessage(message);
    }
}

