/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.jsr223;

import java.util.Map;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.DefaultScriptVariableGenerator;
import org.springframework.integration.scripting.ScriptExecutor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public class ScriptExecutingMessageProcessor
extends AbstractScriptExecutingMessageProcessor<Object> {
    private final ScriptExecutor scriptExecutor;
    private final ScriptSource scriptSource;

    public ScriptExecutingMessageProcessor(ScriptSource scriptSource, ScriptExecutor scriptExecutor) {
        this(scriptSource, new DefaultScriptVariableGenerator(), scriptExecutor);
    }

    public ScriptExecutingMessageProcessor(ScriptSource scriptSource, ScriptVariableGenerator scriptVariableGenerator, ScriptExecutor scriptExecutor) {
        super(scriptVariableGenerator);
        Assert.notNull((Object)scriptSource, (String)"'scriptSource' must not be null");
        Assert.notNull((Object)scriptExecutor, (String)"'scriptExecutor' must not be null");
        this.scriptSource = scriptSource;
        this.scriptExecutor = scriptExecutor;
    }

    public ScriptExecutingMessageProcessor(ScriptSource scriptSource, ScriptExecutor scriptExecutor, Map<String, Object> variables) {
        this(scriptSource, new DefaultScriptVariableGenerator(variables), scriptExecutor);
    }

    @Override
    protected ScriptSource getScriptSource(Message<?> message) {
        return this.scriptSource;
    }

    @Override
    protected Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) {
        Assert.notNull((Object)scriptSource, (String)"scriptSource must not be null");
        return this.scriptExecutor.executeScript(scriptSource, variables);
    }
}

